/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.action;

import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionObserver;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.ProgressBar;
import com.craftingdead.core.world.action.item.ItemAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.immerse.world.action.BuildActionType;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class BuildAction
extends ItemAction {
    private final LivingExtension<?, ?> performer;
    private final BlockPlaceContext context;
    @Nullable
    private List<Placement> placements;

    public BuildAction(LivingExtension<?, ?> performer, BlockPlaceContext context) {
        super(context.m_43724_());
        this.performer = performer;
        this.context = context;
    }

    public BlockPlaceContext getContext() {
        return this.context;
    }

    @Nullable
    protected abstract List<Placement> createPlacements();

    @Nullable
    protected Placement createPlacement(BlockPos blockPos, Block block) {
        BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)this.getContext(), (BlockPos)blockPos, (Direction)this.getContext().m_43719_());
        BlockState blockState = block.m_5573_(context);
        BlockState existingBlockState = this.performer().level().m_8055_(blockPos);
        return existingBlockState.m_60629_(context) && this.type().getPlacementPredicate().test(this.performer, blockPos) ? new Placement(blockPos.m_7949_(), blockState, existingBlockState) : null;
    }

    public boolean start(boolean simulate) {
        this.placements = this.createPlacements();
        return super.start(simulate) && this.placements != null;
    }

    public boolean tick() {
        if (super.tick()) {
            return true;
        }
        if (!this.performer.level().m_5776_() && this.performer.entity().m_20238_(Vec3.m_82512_((Vec3i)this.context.m_8083_())) > 64.0) {
            this.performer.cancelAction(true);
            return false;
        }
        if (this.getTicksUsingItem() % 10 == 0) {
            this.performer().entity().m_5496_(SoundEvents.f_12630_, 1.0f, 1.0f);
            this.placements.forEach(placement -> {
                BlockState currentStae = this.performer().level().m_8055_(placement.blockPos());
                if (placement.existingBlockState() != currentStae) {
                    this.performer().cancelAction(true);
                }
                this.addBuildEffects(placement.blockPos(), placement.blockState());
            });
        }
        return false;
    }

    public void addBuildEffects(BlockPos blockPos, BlockState blockState) {
        this.performer().level().m_142052_(blockPos, blockState);
    }

    public boolean placeBlock(BlockPos blockPos, BlockState blockState) {
        Level level = this.performer().level();
        if (level.m_5776_() || !level.m_46597_(blockPos, blockState)) {
            return false;
        }
        blockState.m_60734_().m_6402_(level, blockPos, blockState, this.performer().entity(), this.getItemStack());
        this.type().getBlockPlacementHandler().accept(this.performer, blockPos);
        LivingEntity livingEntity = this.performer.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CriteriaTriggers.f_10591_.m_59469_(player, blockPos, this.getItemStack());
        }
        return true;
    }

    public ActionObserver createPerformerObserver() {
        return ActionObserver.create((Action)this, (ProgressBar)ProgressBar.create((ActionType)this.type(), null, arg_0 -> ((BuildAction)this).getProgress(arg_0)));
    }

    public LivingExtension<?, ?> performer() {
        return this.performer;
    }

    public abstract BuildActionType type();

    public void stop(Action.StopReason reason) {
        super.stop(reason);
        if (!reason.isCompleted()) {
            return;
        }
        this.placements.forEach(placement -> this.placeBlock(placement.blockPos(), placement.blockState()));
    }

    protected record Placement(BlockPos blockPos, BlockState blockState, BlockState existingBlockState) {
    }
}

