/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.trading.network;

import com.craftingdead.immerse.client.trading.ClientTradePacketHandler;
import com.craftingdead.immerse.trading.TradeRequestManager;
import com.craftingdead.immerse.trading.TradeSession;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class UpdateTradeCurrencyMessage {
    private final int amount;
    private final boolean isOtherPlayer;

    public UpdateTradeCurrencyMessage(int amount, boolean isOtherPlayer) {
        this.amount = amount;
        this.isOtherPlayer = isOtherPlayer;
    }

    public static void encode(UpdateTradeCurrencyMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.amount);
        buffer.writeBoolean(message.isOtherPlayer);
    }

    public static UpdateTradeCurrencyMessage decode(FriendlyByteBuf buffer) {
        return new UpdateTradeCurrencyMessage(buffer.readInt(), buffer.readBoolean());
    }

    public static boolean handle(UpdateTradeCurrencyMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                TradeSession session = TradeRequestManager.getInstance().getTradeSession(player.m_142081_());
                if (session != null) {
                    session.updateCurrency(player, message.amount);
                }
            } else {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientTradePacketHandler.handleUpdateTradeCurrency(message));
            }
        });
        context.setPacketHandled(true);
        return true;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isOtherPlayer() {
        return this.isOtherPlayer;
    }
}

