/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.trading.network;

import com.craftingdead.immerse.client.trading.ClientTradePacketHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class OpenTradeGuiMessage {
    private final UUID otherPlayerId;
    private final Component otherPlayerName;

    public OpenTradeGuiMessage(UUID otherPlayerId, Component otherPlayerName) {
        this.otherPlayerId = otherPlayerId;
        this.otherPlayerName = otherPlayerName;
    }

    public static void encode(OpenTradeGuiMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.otherPlayerId);
        buffer.m_130083_(message.otherPlayerName);
    }

    public static OpenTradeGuiMessage decode(FriendlyByteBuf buffer) {
        return new OpenTradeGuiMessage(buffer.m_130259_(), buffer.m_130238_());
    }

    public static boolean handle(OpenTradeGuiMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientTradePacketHandler.handleOpenTradeGui(message)));
        context.setPacketHandled(true);
        return true;
    }

    public UUID getOtherPlayerId() {
        return this.otherPlayerId;
    }

    public Component getOtherPlayerName() {
        return this.otherPlayerName;
    }
}

