/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.trading;

import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.trading.TradeCancelReason;
import com.craftingdead.immerse.trading.TradeRequestManager;
import com.craftingdead.immerse.trading.network.CancelTradeMessage;
import com.craftingdead.immerse.trading.network.OpenTradeGuiMessage;
import com.craftingdead.immerse.trading.network.TradeCompletedMessage;
import com.craftingdead.immerse.trading.network.UpdateTradeCurrencyMessage;
import com.craftingdead.immerse.trading.network.UpdateTradeSlotMessage;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;

public class TradeSession {
    private static final Logger logger = LogUtils.getLogger();
    public static final int MAX_TRADE_SLOTS = 9;
    private final ServerPlayer player1;
    private final ServerPlayer player2;
    private final List<ItemStack> player1Items;
    private final List<ItemStack> player2Items;
    private int player1Currency;
    private int player2Currency;
    private boolean player1Confirmed;
    private boolean player2Confirmed;
    private boolean player1SlotsLocked;
    private boolean player2SlotsLocked;

    public TradeSession(ServerPlayer player1, ServerPlayer player2) {
        this.player1 = player1;
        this.player2 = player2;
        this.player1Items = new ArrayList<ItemStack>(9);
        this.player2Items = new ArrayList<ItemStack>(9);
        for (int i = 0; i < 9; ++i) {
            this.player1Items.add(ItemStack.f_41583_);
            this.player2Items.add(ItemStack.f_41583_);
        }
        this.player1Currency = 0;
        this.player2Currency = 0;
        this.player1Confirmed = false;
        this.player2Confirmed = false;
        this.player1SlotsLocked = false;
        this.player2SlotsLocked = false;
    }

    public void initialize() {
        logger.debug("Initializing trade session between {} and {}", (Object)this.player1.m_36316_().getName(), (Object)this.player2.m_36316_().getName());
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> this.player1), (Object)new OpenTradeGuiMessage(this.player2.m_142081_(), this.player2.m_5446_()));
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> this.player2), (Object)new OpenTradeGuiMessage(this.player1.m_142081_(), this.player1.m_5446_()));
        this.player1.m_6352_((Component)new TranslatableComponent("trade.started", new Object[]{this.player2.m_5446_()}).m_130940_(ChatFormatting.GREEN), this.player1.m_142081_());
        this.player2.m_6352_((Component)new TranslatableComponent("trade.started", new Object[]{this.player1.m_5446_()}).m_130940_(ChatFormatting.GREEN), this.player2.m_142081_());
    }

    public boolean updateSlot(ServerPlayer player, int slotIndex, ItemStack itemStack) {
        boolean isLocked;
        if (slotIndex < 0 || slotIndex >= 9) {
            return false;
        }
        boolean isPlayer1 = player.m_142081_().equals(this.player1.m_142081_());
        List<ItemStack> items = isPlayer1 ? this.player1Items : this.player2Items;
        boolean bl = isLocked = isPlayer1 ? this.player1SlotsLocked : this.player2SlotsLocked;
        if (isLocked) {
            player.m_6352_((Component)new TranslatableComponent("trade.error.slots_locked").m_130940_(ChatFormatting.RED), player.m_142081_());
            return false;
        }
        if (!itemStack.m_41619_()) {
            boolean hasItem = false;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack invStack = player.m_150109_().m_8020_(i);
                if (!ItemStack.m_41746_((ItemStack)invStack, (ItemStack)itemStack) || invStack.m_41613_() < itemStack.m_41613_()) continue;
                hasItem = true;
                break;
            }
            if (!hasItem) {
                logger.warn("Player {} tried to trade item they don't have: {}", (Object)player.m_36316_().getName(), (Object)itemStack);
                return false;
            }
        }
        items.set(slotIndex, itemStack.m_41777_());
        if (this.player1Confirmed || this.player2Confirmed) {
            this.player1Confirmed = false;
            this.player2Confirmed = false;
            this.player1SlotsLocked = false;
            this.player2SlotsLocked = false;
            this.player1.m_6352_((Component)new TranslatableComponent("trade.confirmation_reset").m_130940_(ChatFormatting.YELLOW), this.player1.m_142081_());
            this.player2.m_6352_((Component)new TranslatableComponent("trade.confirmation_reset").m_130940_(ChatFormatting.YELLOW), this.player2.m_142081_());
        }
        ServerPlayer otherPlayer = isPlayer1 ? this.player2 : this.player1;
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> otherPlayer), (Object)new UpdateTradeSlotMessage(slotIndex, itemStack, false));
        return true;
    }

    public boolean updateCurrency(ServerPlayer player, int amount) {
        boolean isLocked;
        if (amount < 0) {
            return false;
        }
        boolean isPlayer1 = player.m_142081_().equals(this.player1.m_142081_());
        boolean bl = isLocked = isPlayer1 ? this.player1SlotsLocked : this.player2SlotsLocked;
        if (isLocked) {
            player.m_6352_((Component)new TranslatableComponent("trade.error.slots_locked").m_130940_(ChatFormatting.RED), player.m_142081_());
            return false;
        }
        if (isPlayer1) {
            this.player1Currency = amount;
        } else {
            this.player2Currency = amount;
        }
        if (this.player1Confirmed || this.player2Confirmed) {
            this.player1Confirmed = false;
            this.player2Confirmed = false;
            this.player1SlotsLocked = false;
            this.player2SlotsLocked = false;
            this.player1.m_6352_((Component)new TranslatableComponent("trade.confirmation_reset").m_130940_(ChatFormatting.YELLOW), this.player1.m_142081_());
            this.player2.m_6352_((Component)new TranslatableComponent("trade.confirmation_reset").m_130940_(ChatFormatting.YELLOW), this.player2.m_142081_());
        }
        ServerPlayer otherPlayer = isPlayer1 ? this.player2 : this.player1;
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> otherPlayer), (Object)new UpdateTradeCurrencyMessage(amount, false));
        return true;
    }

    public boolean toggleConfirm(ServerPlayer player) {
        boolean isPlayer1 = player.m_142081_().equals(this.player1.m_142081_());
        if (isPlayer1) {
            this.player1SlotsLocked = this.player1Confirmed = !this.player1Confirmed;
            player.m_6352_((Component)(this.player1Confirmed ? new TranslatableComponent("trade.confirmed").m_130940_(ChatFormatting.GREEN) : new TranslatableComponent("trade.unconfirmed").m_130940_(ChatFormatting.YELLOW)), player.m_142081_());
        } else {
            this.player2SlotsLocked = this.player2Confirmed = !this.player2Confirmed;
            player.m_6352_((Component)(this.player2Confirmed ? new TranslatableComponent("trade.confirmed").m_130940_(ChatFormatting.GREEN) : new TranslatableComponent("trade.unconfirmed").m_130940_(ChatFormatting.YELLOW)), player.m_142081_());
        }
        if (this.player1Confirmed && this.player2Confirmed) {
            this.executeTrade();
        }
        return true;
    }

    private void executeTrade() {
        logger.info("Executing trade between {} and {}", (Object)this.player1.m_36316_().getName(), (Object)this.player2.m_36316_().getName());
        try {
            if (!TradeRequestManager.arePlayersInRange(this.player1, this.player2)) {
                this.cancel(TradeCancelReason.OUT_OF_RANGE);
                return;
            }
            for (ItemStack stack : this.player1Items) {
                if (stack.m_41619_() || this.removeItemFromInventory(this.player1, stack)) continue;
                logger.error("Failed to remove item {} from player {}", (Object)stack, (Object)this.player1.m_36316_().getName());
                this.cancel(TradeCancelReason.ERROR);
                return;
            }
            for (ItemStack stack : this.player2Items) {
                if (stack.m_41619_() || this.removeItemFromInventory(this.player2, stack)) continue;
                for (ItemStack stack1 : this.player1Items) {
                    if (stack1.m_41619_()) continue;
                    this.player1.m_150109_().m_36054_(stack1.m_41777_());
                }
                logger.error("Failed to remove item {} from player {}", (Object)stack, (Object)this.player2.m_36316_().getName());
                this.cancel(TradeCancelReason.ERROR);
                return;
            }
            for (ItemStack stack : this.player1Items) {
                if (stack.m_41619_() || this.player2.m_150109_().m_36054_(stack.m_41777_())) continue;
                this.player2.m_36176_(stack.m_41777_(), false);
            }
            for (ItemStack stack : this.player2Items) {
                if (stack.m_41619_() || this.player1.m_150109_().m_36054_(stack.m_41777_())) continue;
                this.player1.m_36176_(stack.m_41777_(), false);
            }
            this.player1.m_6352_((Component)new TranslatableComponent("trade.completed").m_130940_(ChatFormatting.GREEN), this.player1.m_142081_());
            this.player2.m_6352_((Component)new TranslatableComponent("trade.completed").m_130940_(ChatFormatting.GREEN), this.player2.m_142081_());
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> this.player1), (Object)new TradeCompletedMessage());
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> this.player2), (Object)new TradeCompletedMessage());
            TradeRequestManager.getInstance().removeTradeSession(this);
        }
        catch (Exception e) {
            logger.error("Error executing trade", (Throwable)e);
            this.cancel(TradeCancelReason.ERROR);
        }
    }

    public void cancel(TradeCancelReason reason) {
        logger.debug("Cancelling trade between {} and {}: {}", new Object[]{this.player1.m_36316_().getName(), this.player2.m_36316_().getName(), reason});
        this.player1.m_6352_((Component)new TranslatableComponent(reason.getTranslationKey()).m_130940_(ChatFormatting.RED), this.player1.m_142081_());
        this.player2.m_6352_((Component)new TranslatableComponent(reason.getTranslationKey()).m_130940_(ChatFormatting.RED), this.player2.m_142081_());
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> this.player1), (Object)new CancelTradeMessage(reason));
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> this.player2), (Object)new CancelTradeMessage(reason));
        TradeRequestManager.getInstance().removeTradeSession(this);
    }

    private boolean removeItemFromInventory(ServerPlayer player, ItemStack stack) {
        int remaining = stack.m_41613_();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack invStack = player.m_150109_().m_8020_(i);
            if (!ItemStack.m_41746_((ItemStack)invStack, (ItemStack)stack) || !ItemStack.m_41658_((ItemStack)invStack, (ItemStack)stack)) continue;
            int toRemove = Math.min(remaining, invStack.m_41613_());
            invStack.m_41774_(toRemove);
            if ((remaining -= toRemove) > 0) continue;
            return true;
        }
        return remaining == 0;
    }

    public ServerPlayer getPlayer1() {
        return this.player1;
    }

    public ServerPlayer getPlayer2() {
        return this.player2;
    }

    public List<ItemStack> getPlayer1Items() {
        return this.player1Items;
    }

    public List<ItemStack> getPlayer2Items() {
        return this.player2Items;
    }

    public int getPlayer1Currency() {
        return this.player1Currency;
    }

    public int getPlayer2Currency() {
        return this.player2Currency;
    }

    public boolean isPlayer1Confirmed() {
        return this.player1Confirmed;
    }

    public boolean isPlayer2Confirmed() {
        return this.player2Confirmed;
    }
}

