/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.trading;

import com.craftingdead.immerse.trading.TradeCancelReason;
import com.craftingdead.immerse.trading.TradeSession;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class TradeRequestManager {
    public static final double MAX_TRADE_DISTANCE = 5.0;
    private static final long REQUEST_COOLDOWN_MS = 3000L;
    private static final long REQUEST_TIMEOUT_MS = 30000L;
    private static final TradeRequestManager INSTANCE = new TradeRequestManager();
    private final Map<UUID, PendingRequest> pendingRequests = new HashMap<UUID, PendingRequest>();
    private final Map<UUID, Long> requestCooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, TradeSession> activeSessions = new HashMap<UUID, TradeSession>();

    private TradeRequestManager() {
    }

    public static TradeRequestManager getInstance() {
        return INSTANCE;
    }

    public boolean sendTradeRequest(ServerPlayer requester, ServerPlayer target) {
        if (requester.m_142081_().equals(target.m_142081_())) {
            requester.m_6352_((Component)new TranslatableComponent("trade.error.self").m_130940_(ChatFormatting.RED), requester.m_142081_());
            return false;
        }
        if (this.isInTrade(requester.m_142081_())) {
            requester.m_6352_((Component)new TranslatableComponent("trade.error.already_trading").m_130940_(ChatFormatting.RED), requester.m_142081_());
            return false;
        }
        if (this.isInTrade(target.m_142081_())) {
            requester.m_6352_((Component)new TranslatableComponent("trade.error.target_busy", new Object[]{target.m_5446_()}).m_130940_(ChatFormatting.RED), requester.m_142081_());
            return false;
        }
        if (!TradeRequestManager.arePlayersInRange(requester, target)) {
            requester.m_6352_((Component)new TranslatableComponent("trade.error.too_far", new Object[]{target.m_5446_()}).m_130940_(ChatFormatting.RED), requester.m_142081_());
            return false;
        }
        long currentTime = System.currentTimeMillis();
        Long lastRequest = this.requestCooldowns.get(requester.m_142081_());
        if (lastRequest != null && currentTime - lastRequest < 3000L) {
            long remaining = (3000L - (currentTime - lastRequest)) / 1000L;
            requester.m_6352_((Component)new TranslatableComponent("trade.error.cooldown", new Object[]{remaining}).m_130940_(ChatFormatting.RED), requester.m_142081_());
            return false;
        }
        this.pendingRequests.remove(requester.m_142081_());
        PendingRequest request = new PendingRequest(target.m_142081_(), currentTime);
        this.pendingRequests.put(requester.m_142081_(), request);
        this.requestCooldowns.put(requester.m_142081_(), currentTime);
        requester.m_6352_((Component)new TranslatableComponent("trade.request.sent", new Object[]{target.m_5446_()}).m_130940_(ChatFormatting.GREEN), requester.m_142081_());
        MutableComponent acceptButton = new TextComponent("[\u2713 Accept]").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/trade accept " + requester.m_36316_().getName())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("trade.request.hover.accept"))));
        MutableComponent denyButton = new TextComponent("[\u2717 Deny]").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/trade deny " + requester.m_36316_().getName())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("trade.request.hover.deny"))));
        MutableComponent message = new TranslatableComponent("trade.request.received", new Object[]{requester.m_5446_()}).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TextComponent(" ")).m_7220_((Component)acceptButton).m_7220_((Component)new TextComponent(" ")).m_7220_((Component)denyButton);
        target.m_6352_((Component)message, target.m_142081_());
        return true;
    }

    public boolean acceptTradeRequest(ServerPlayer accepter, ServerPlayer requester) {
        UUID accepterId = accepter.m_142081_();
        UUID requesterId = requester.m_142081_();
        PendingRequest request = this.pendingRequests.get(requesterId);
        if (request == null || !request.targetId.equals(accepterId)) {
            accepter.m_6352_((Component)new TranslatableComponent("trade.error.no_request", new Object[]{requester.m_5446_()}).m_130940_(ChatFormatting.RED), accepterId);
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - request.timestamp > 30000L) {
            this.pendingRequests.remove(requesterId);
            accepter.m_6352_((Component)new TranslatableComponent("trade.error.expired").m_130940_(ChatFormatting.RED), accepterId);
            return false;
        }
        if (this.isInTrade(accepterId) || this.isInTrade(requesterId)) {
            this.pendingRequests.remove(requesterId);
            accepter.m_6352_((Component)new TranslatableComponent("trade.error.already_trading").m_130940_(ChatFormatting.RED), accepterId);
            return false;
        }
        if (!TradeRequestManager.arePlayersInRange(accepter, requester)) {
            this.pendingRequests.remove(requesterId);
            accepter.m_6352_((Component)new TranslatableComponent("trade.error.too_far", new Object[]{requester.m_5446_()}).m_130940_(ChatFormatting.RED), accepterId);
            return false;
        }
        this.pendingRequests.remove(requesterId);
        TradeSession session = new TradeSession(requester, accepter);
        this.activeSessions.put(requesterId, session);
        this.activeSessions.put(accepterId, session);
        session.initialize();
        return true;
    }

    public boolean denyTradeRequest(ServerPlayer denier, ServerPlayer requester) {
        UUID denierId = denier.m_142081_();
        UUID requesterId = requester.m_142081_();
        PendingRequest request = this.pendingRequests.get(requesterId);
        if (request == null || !request.targetId.equals(denierId)) {
            denier.m_6352_((Component)new TranslatableComponent("trade.error.no_request", new Object[]{requester.m_5446_()}).m_130940_(ChatFormatting.RED), denierId);
            return false;
        }
        this.pendingRequests.remove(requesterId);
        denier.m_6352_((Component)new TranslatableComponent("trade.request.denied.self", new Object[]{requester.m_5446_()}).m_130940_(ChatFormatting.YELLOW), denierId);
        requester.m_6352_((Component)new TranslatableComponent("trade.request.denied.other", new Object[]{denier.m_5446_()}).m_130940_(ChatFormatting.RED), requesterId);
        return true;
    }

    @Nullable
    public TradeSession getTradeSession(UUID playerId) {
        return this.activeSessions.get(playerId);
    }

    public boolean isInTrade(UUID playerId) {
        return this.activeSessions.containsKey(playerId);
    }

    public void removeTradeSession(TradeSession session) {
        this.activeSessions.remove(session.getPlayer1().m_142081_());
        this.activeSessions.remove(session.getPlayer2().m_142081_());
    }

    public static boolean arePlayersInRange(ServerPlayer player1, ServerPlayer player2) {
        Vec3 pos2;
        if (player1.f_19853_ != player2.f_19853_) {
            return false;
        }
        Vec3 pos1 = player1.m_20182_();
        return pos1.m_82554_(pos2 = player2.m_20182_()) <= 5.0;
    }

    public void tick() {
        long currentTime = System.currentTimeMillis();
        this.pendingRequests.entrySet().removeIf(entry -> currentTime - ((PendingRequest)entry.getValue()).timestamp > 30000L);
        for (TradeSession session : this.activeSessions.values()) {
            if (TradeRequestManager.arePlayersInRange(session.getPlayer1(), session.getPlayer2())) continue;
            session.cancel(TradeCancelReason.OUT_OF_RANGE);
        }
    }

    public void cleanupPlayer(UUID playerId) {
        TradeSession session = this.activeSessions.get(playerId);
        if (session != null) {
            session.cancel(TradeCancelReason.PLAYER_DISCONNECT);
        }
        this.pendingRequests.remove(playerId);
        this.requestCooldowns.remove(playerId);
    }

    private static class PendingRequest {
        private final UUID targetId;
        private final long timestamp;

        PendingRequest(UUID targetId, long timestamp) {
            this.targetId = targetId;
            this.timestamp = timestamp;
        }
    }
}

