/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.server;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> gameRotation;
    public final ForgeConfigSpec.EnumValue<NametagMode> nametagMode;
    public final ForgeConfigSpec.IntValue hydrateCommandCooldownMinutes;
    public final ForgeConfigSpec.BooleanValue thirstEnabled;
    public final ForgeConfigSpec.DoubleValue thirstDifficultyMultiplier;
    public final ForgeConfigSpec.IntValue thirstDecayIntervalTicks;
    public final ForgeConfigSpec.IntValue thirstDecayAmount;
    public final ForgeConfigSpec.IntValue thirstSprintingDecayAmount;
    public final ForgeConfigSpec.IntValue thirstDamageIntervalTicks;

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("server");
        this.gameRotation = builder.translation("options.craftingdeadimmerse.server.game_rotation").defineList("game_rotation", (List)ImmutableList.of(), gameName -> true);
        builder.pop();
        builder.push("gameplay");
        this.nametagMode = builder.translation("options.craftingdeadimmerse.gameplay.nametag_mode").comment(new String[]{"Allows to define how nametags should be shown to the player.", "DEFAULT: Default minecraft behaviour", "LOOK: The player must be looking at another player to see it's nametag", "HIDE_PLAYER: Hide player nametags", "HIDE_ALL: Hide all nametags"}).defineEnum("nametag_mode", (Enum)NametagMode.DEFAULT);
        this.hydrateCommandCooldownMinutes = builder.translation("options.craftingdeadimmerse.gameplay.hydrate_command_cooldown_minutes").comment(new String[]{"Cooldown, in minutes, applied to players using the /hydrate command.", "Set to 0 to disable the cooldown entirely."}).defineInRange("hydrate_command_cooldown_minutes", 30, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.comment("Configure thirst/hydration system behavior").push("thirst");
        this.thirstEnabled = builder.translation("options.craftingdeadimmerse.server.thirst.enabled").comment("Master toggle for the thirst system. When disabled, players will not lose thirst.").define("enabled", true);
        this.thirstDifficultyMultiplier = builder.translation("options.craftingdeadimmerse.server.thirst.difficulty_multiplier").comment("Global multiplier for thirst decay rates. Higher = harder (0.5 = easy, 1.0 = normal, 2.0 = hard)").defineInRange("difficulty_multiplier", 1.0, 0.1, 10.0);
        this.thirstDecayIntervalTicks = builder.translation("options.craftingdeadimmerse.server.thirst.decay_interval_ticks").comment("How often (in ticks) thirst decays naturally (20 ticks = 1 second)").defineInRange("decay_interval_ticks", 800, 1, Integer.MAX_VALUE);
        this.thirstDecayAmount = builder.translation("options.craftingdeadimmerse.server.thirst.decay_amount").comment("Amount of thirst lost per decay interval when standing still or walking").defineInRange("decay_amount", 5, 1, 100);
        this.thirstSprintingDecayAmount = builder.translation("options.craftingdeadimmerse.server.thirst.sprinting_decay_amount").comment("Amount of thirst lost per decay interval when sprinting").defineInRange("sprinting_decay_amount", 10, 1, 100);
        this.thirstDamageIntervalTicks = builder.translation("options.craftingdeadimmerse.server.thirst.damage_interval_ticks").comment("How often (in ticks) the player takes damage when fully dehydrated").defineInRange("damage_interval_ticks", 120, 1, Integer.MAX_VALUE);
        builder.pop();
    }

    public static enum NametagMode {
        DEFAULT,
        LOOK,
        HIDE_PLAYER,
        HIDE_ALL;

    }
}

