/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.network.play;

import com.craftingdead.immerse.world.level.extension.LandOwner;
import com.craftingdead.immerse.world.level.extension.LevelExtension;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;

public record SyncLandOwnerMessage(UUID landOwnerId, CompoundTag tag) {
    public void encode(FriendlyByteBuf out) {
        out.m_130077_(this.landOwnerId);
        out.m_130079_(this.tag);
    }

    public static SyncLandOwnerMessage decode(FriendlyByteBuf in) {
        return new SyncLandOwnerMessage(in.m_130259_(), in.m_130260_());
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ((Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide())).map(LevelExtension::getOrThrow).map(LevelExtension::getLandManager).ifPresent(landManager -> {
            LandOwner landOwner = landManager.getLandOwner(this.landOwnerId);
            if (landOwner == null) {
                throw new IllegalStateException("Missing land owner: " + this.landOwnerId.toString());
            }
            landOwner.handleUpdateTag(this.tag);
        }));
        return true;
    }
}

