/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.mixin;

import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.game.Game;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FireBlock;
import net.minecraftforge.fml.LogicalSide;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FireBlock.class})
public class FireBlockMixin {
    @Inject(method={"tryCatchFire"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void tryCatchFire(Level level, BlockPos pos, int chance, Random random, int age, Direction face, CallbackInfo callbackInfo) {
        if (this.blockBurningDisabled(level)) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"canCatchFire"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void canCatchFire(BlockGetter blockGetter, BlockPos pos, Direction face, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (blockGetter instanceof Level && this.blockBurningDisabled((Level)blockGetter)) {
            callbackInfo.setReturnValue((Object)false);
        }
    }

    private boolean blockBurningDisabled(Level level) {
        Game game = CraftingDeadImmerse.getInstance().getGame(level.m_5776_() ? LogicalSide.CLIENT : LogicalSide.SERVER);
        return game != null && game.disableBlockBurning();
    }
}

