/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm.state;

import com.craftingdead.immerse.game.GameUtil;
import com.craftingdead.immerse.game.tdm.TdmServer;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import com.craftingdead.immerse.util.state.State;
import com.craftingdead.immerse.util.state.TimedStateInstance;
import net.minecraft.sounds.SoundEvent;

public class PreGameStateInstance
extends TimedStateInstance<TdmServer> {
    public PreGameStateInstance(State<?> state, TdmServer context) {
        super(state, context, context.getPreGameDuration());
    }

    @Override
    public boolean tick() {
        boolean redEmpty = ((TdmServer)this.getContext()).getTeamModule().getTeamInstance(TdmTeam.RED).getMembers().isEmpty();
        boolean blueEmpty = ((TdmServer)this.getContext()).getTeamModule().getTeamInstance(TdmTeam.BLUE).getMembers().isEmpty();
        if (redEmpty || blueEmpty) {
            return false;
        }
        if (super.tick()) {
            ((TdmServer)this.getContext()).setMovementBlocked(false);
            ((TdmServer)this.getContext()).resetBuyTimes();
            ((TdmServer)this.getContext()).resetPlayerData();
            ((TdmServer)this.getContext()).resetTeams();
            ((TdmServer)this.getContext()).getLogicalServer().respawnPlayers(playerEntity -> !playerEntity.m_5833_(), false);
            GameUtil.broadcastSound((SoundEvent)ImmerseSoundEvents.START_MUSIC.get(), ((TdmServer)this.getContext()).getMinecraftServer());
            return true;
        }
        if (((TdmServer)this.getContext()).getMinecraftServer().m_7416_() > 5 && this.getTimeRemainingSeconds() > 16L) {
            this.setTimeRemainingSeconds(15L);
        }
        if (this.getTimeRemainingSeconds() <= 15L && this.hasSecondPast()) {
            GameUtil.broadcastSound((SoundEvent)ImmerseSoundEvents.COUNTDOWN.get(), ((TdmServer)this.getContext()).getMinecraftServer());
        }
        if (this.getTimeRemainingSeconds() <= 5L) {
            ((TdmServer)this.getContext()).setMovementBlocked(true);
        }
        return false;
    }
}

