/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.network.SynchedData;
import com.craftingdead.immerse.game.module.team.Team;
import com.craftingdead.immerse.game.module.team.TeamInstance;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;

public enum TdmTeam implements Team
{
    RED("Red", ChatFormatting.RED.m_126665_(), new ResourceLocation("craftingdeadimmerse", "textures/skins/red_team.png")),
    BLUE("Blue", ChatFormatting.BLUE.m_126665_(), new ResourceLocation("craftingdeadimmerse", "textures/skins/blue_team.png"));

    private static final EntityDataAccessor<Integer> SCORE;
    private final String name;
    private final int colour;
    private final ResourceLocation skin;

    private TdmTeam(String name, int colour, ResourceLocation skin) {
        this.name = name;
        this.colour = colour;
        this.skin = skin;
    }

    public static void incrementScore(TeamInstance<?> team) {
        team.getDataManager().compute(SCORE, score -> {
            score = score + 1;
            return score;
        });
    }

    public static int getScore(TeamInstance<?> teamInstance) {
        return (Integer)teamInstance.getDataManager().get(SCORE);
    }

    public static void reset(TeamInstance<?> teamInstance) {
        teamInstance.getDataManager().set(SCORE, (Object)0);
    }

    @Override
    public Optional<ResourceLocation> getSkin() {
        return Optional.of(this.skin);
    }

    @Override
    public void registerDataParameters(SynchedData dataManager) {
        dataManager.register(SCORE, (Object)0);
    }

    @Override
    public void save(TeamInstance<?> teamInstance, CompoundTag nbt) {
    }

    @Override
    public void load(TeamInstance<?> teamInstance, CompoundTag nbt) {
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        SCORE = new EntityDataAccessor(0, EntityDataSerializers.f_135028_);
    }
}

