/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.combatslot.CombatSlot;
import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.game.GameServer;
import com.craftingdead.immerse.game.GameUtil;
import com.craftingdead.immerse.game.LogicalServer;
import com.craftingdead.immerse.game.PlayerRemovalReason;
import com.craftingdead.immerse.game.module.ServerModule;
import com.craftingdead.immerse.game.module.shop.ServerShopModule;
import com.craftingdead.immerse.game.module.shop.ShopCategory;
import com.craftingdead.immerse.game.module.shop.ShopItem;
import com.craftingdead.immerse.game.module.team.ServerTeamModule;
import com.craftingdead.immerse.game.module.team.TeamInstance;
import com.craftingdead.immerse.game.tdm.TdmGame;
import com.craftingdead.immerse.game.tdm.TdmPlayerHandler;
import com.craftingdead.immerse.game.tdm.TdmServerPlayerHandler;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.game.tdm.message.TdmServerMessage;
import com.craftingdead.immerse.game.tdm.state.GameStateInstance;
import com.craftingdead.immerse.game.tdm.state.TdmState;
import com.craftingdead.immerse.util.state.State;
import com.craftingdead.immerse.util.state.StateInstance;
import com.craftingdead.immerse.util.state.StateMachine;
import com.craftingdead.immerse.util.state.TimedStateInstance;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class TdmServer
extends TdmGame
implements GameServer,
ServerTeamModule.TeamHandler<TdmTeam> {
    public static final Codec<TdmServer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("display_name").forGetter(TdmGame::getDisplayName), (App)Codec.INT.optionalFieldOf("maxScore", (Object)100).forGetter(TdmServer::getMaxScore), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("pre_game_duration", (Object)Duration.ofMinutes(1L)).forGetter(TdmServer::getPreGameDuration), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("game_duration", (Object)Duration.ofMinutes(10L)).forGetter(TdmServer::getPreGameDuration), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("post_game_duration", (Object)Duration.ofSeconds(30L)).forGetter(TdmServer::getPreGameDuration), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("buy_duration", (Object)Duration.ofSeconds(20L)).forGetter(TdmServer::getPreGameDuration), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("spawn_protection_duration", (Object)Duration.ofSeconds(8L)).forGetter(TdmServer::getPreGameDuration), (App)Codec.STRING.xmap(Duration::parse, Duration::toString).optionalFieldOf("ghost_duration", (Object)Duration.ofSeconds(5L)).forGetter(TdmServer::getPreGameDuration), (App)GlobalPos.f_122633_.fieldOf("red_spawn_point").forGetter(TdmServer::getRedSpawnPoint), (App)GlobalPos.f_122633_.fieldOf("blue_spawn_point").forGetter(TdmServer::getBlueSpawnPoint)).apply((Applicative)instance, TdmServer::new));
    private static final Component NO_SWITCH_TEAM = new TranslatableComponent("message.no_switch_team");
    private final LogicalServer logicalServer = CraftingDeadImmerse.getInstance().getLogicalServer();
    private final StateMachine<TdmState, TdmServer> stateMachine;
    private ServerShopModule shopModule;
    private ServerTeamModule<TdmTeam> teamModule;
    private final int maxScore;
    private final Duration preGameDuration;
    private final Duration gameDuration;
    private final Duration postGameDuration;
    private final Duration buyDuration;
    private final Duration spawnProtectionDuration;
    private final Duration ghostDuration;
    private final GlobalPos redSpawnPoint;
    private final GlobalPos blueSpawnPoint;
    private boolean daylightCycleOld;
    private boolean weatherCycleOld;
    private boolean showDeathMessagesOld;
    private boolean naturalRegenerationOld;
    private boolean immediateRespawnOld;
    private Difficulty oldDifficulty;
    private boolean firstBloodDrawn;
    private boolean finished;

    public TdmServer(String displayName, int maxScore, Duration preGameDuration, Duration gameDuration, Duration postGameDuration, Duration buyDuration, Duration spawnProtectionDuration, Duration ghostDuration, GlobalPos redSpawnPoint, GlobalPos blueSpawnPoint) {
        super(displayName);
        this.maxScore = maxScore;
        this.preGameDuration = preGameDuration;
        this.gameDuration = gameDuration;
        this.postGameDuration = postGameDuration;
        this.buyDuration = buyDuration;
        this.spawnProtectionDuration = spawnProtectionDuration;
        this.ghostDuration = ghostDuration;
        this.stateMachine = new StateMachine((Object)this, (State[])TdmState.values(), this::setGameState);
        this.redSpawnPoint = redSpawnPoint;
        this.blueSpawnPoint = blueSpawnPoint;
    }

    public int getMaxScore() {
        return this.maxScore;
    }

    public Duration getPreGameDuration() {
        return this.preGameDuration;
    }

    public Duration getGameDuration() {
        return this.gameDuration;
    }

    public Duration getPostGameDuration() {
        return this.postGameDuration;
    }

    public Duration getBuyDuration() {
        return this.buyDuration;
    }

    public Duration getSpawnProtectionDuration() {
        return this.spawnProtectionDuration;
    }

    public Duration getGhostDuration() {
        return this.ghostDuration;
    }

    public GlobalPos getRedSpawnPoint() {
        return this.redSpawnPoint;
    }

    public GlobalPos getBlueSpawnPoint() {
        return this.blueSpawnPoint;
    }

    public LogicalServer getLogicalServer() {
        return this.logicalServer;
    }

    public MinecraftServer getMinecraftServer() {
        return this.getLogicalServer().getMinecraftServer();
    }

    public void resetBuyTimes() {
        this.getMinecraftServer().m_6846_().m_11314_().stream().map(PlayerExtension::getOrThrow).map(player -> (TdmServerPlayerHandler)player.getHandlerOrThrow(TdmPlayerHandler.TYPE)).forEach(TdmServerPlayerHandler::resetBuyTime);
    }

    public void resetPlayerData() {
        for (ServerPlayer playerEntity : this.getMinecraftServer().m_6846_().m_11314_()) {
            this.deletePlayerData(playerEntity.m_142081_());
        }
    }

    public void resetTeams() {
        for (TdmTeam team : TdmTeam.values()) {
            TdmTeam.reset(this.getTeamModule().getTeamInstance(team));
        }
    }

    @Override
    public <MSG> void handleMessage(MSG message, NetworkEvent.Context context) {
        if (message instanceof TdmServerMessage) {
            ((TdmServerMessage)message).handle(this, context);
        }
    }

    @Override
    public Optional<GlobalPos> getSpawnPoint(PlayerExtension<ServerPlayer> player) {
        return this.getTeamModule().getPlayerTeam(((ServerPlayer)player.entity()).m_142081_()).map(team -> team == TdmTeam.RED ? this.getRedSpawnPoint() : this.getBlueSpawnPoint());
    }

    @Override
    public void tick() {
        if (this.stateMachine.getCurrentState().getState() == TdmState.IDLE && this.getMinecraftServer().m_7416_() > 0) {
            this.stateMachine.nextState();
        }
        if (this.stateMachine.getCurrentState() instanceof TimedStateInstance) {
            this.setTimerValueSeconds((int)((TimedStateInstance)this.stateMachine.getCurrentState()).getTimeRemainingSeconds());
        } else {
            this.setTimerValueSeconds(0);
        }
        this.finished = this.stateMachine.tick();
    }

    @Override
    public void load() {
        GameRules gameRules = this.getMinecraftServer().m_129900_();
        GameRules.BooleanValue daylightCycle = (GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46140_);
        this.daylightCycleOld = daylightCycle.m_46223_();
        daylightCycle.m_46246_(false, this.getMinecraftServer());
        GameRules.BooleanValue weatherCycle = (GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46150_);
        this.weatherCycleOld = weatherCycle.m_46223_();
        weatherCycle.m_46246_(false, this.getMinecraftServer());
        GameRules.BooleanValue showDeathMessages = (GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46142_);
        this.showDeathMessagesOld = showDeathMessages.m_46223_();
        showDeathMessages.m_46246_(false, this.getMinecraftServer());
        GameRules.BooleanValue naturalRegeneration = (GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46139_);
        this.naturalRegenerationOld = naturalRegeneration.m_46223_();
        naturalRegeneration.m_46246_(false, this.getMinecraftServer());
        GameRules.BooleanValue immediateRespawn = (GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46156_);
        this.immediateRespawnOld = immediateRespawn.m_46223_();
        immediateRespawn.m_46246_(true, this.getMinecraftServer());
        ServerLevel level = this.getMinecraftServer().m_129880_(Level.f_46428_);
        level.m_8606_(6000, 0, false, false);
        level.m_8615_(1000L);
        this.oldDifficulty = this.getMinecraftServer().m_129910_().m_5472_();
        this.getMinecraftServer().m_129827_(Difficulty.PEACEFUL, true);
        super.load();
    }

    @Override
    public void unload() {
        GameRules gameRules = this.getMinecraftServer().m_129900_();
        ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46140_)).m_46246_(this.daylightCycleOld, this.getMinecraftServer());
        ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46150_)).m_46246_(this.weatherCycleOld, this.getMinecraftServer());
        ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46142_)).m_46246_(this.showDeathMessagesOld, this.getMinecraftServer());
        ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46139_)).m_46246_(this.naturalRegenerationOld, this.getMinecraftServer());
        ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46156_)).m_46246_(this.immediateRespawnOld, this.getMinecraftServer());
        this.getMinecraftServer().m_129827_(this.oldDifficulty, true);
        for (ServerPlayer playerEntity : this.getMinecraftServer().m_6846_().m_11314_()) {
            ((TdmServerPlayerHandler)PlayerExtension.getOrThrow((Player)playerEntity).getHandlerOrThrow(TdmPlayerHandler.TYPE)).invalidate();
        }
        super.unload();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @SubscribeEvent
    public void handleLivingExtensionLoad(LivingExtensionEvent.Load event) {
        PlayerExtension player;
        LivingExtension livingExtension = event.getLiving();
        if (livingExtension instanceof PlayerExtension && !(player = (PlayerExtension)livingExtension).level().m_5776_()) {
            player.registerHandler(TdmPlayerHandler.TYPE, (LivingHandler)new TdmServerPlayerHandler(this, (PlayerExtension<ServerPlayer>)player));
        }
    }

    @Override
    public void addPlayer(PlayerExtension<ServerPlayer> player) {
        ((ServerTeamModule)this.getTeamModule()).setPlayerTeam(player, null);
        GameUtil.sendGameMessageToAll((Component)new TranslatableComponent("message.joined", new Object[]{((ServerPlayer)player.entity()).m_5446_()}).m_130940_(ChatFormatting.WHITE), this.getMinecraftServer());
    }

    @Override
    public void removePlayer(PlayerExtension<ServerPlayer> player, PlayerRemovalReason reason) {
        player.removeHandler(TdmPlayerHandler.TYPE);
        ((ServerTeamModule)this.getTeamModule()).setPlayerTeam(player, null);
        this.deletePlayerData(((ServerPlayer)player.entity()).m_142081_());
        GameUtil.sendGameMessageToAll((Component)new TranslatableComponent("message.left", new Object[]{((ServerPlayer)player.entity()).m_5446_()}).m_130940_(ChatFormatting.WHITE), this.getMinecraftServer());
    }

    @Override
    public boolean persistPlayerData() {
        return false;
    }

    @Override
    public boolean persistGameData() {
        return false;
    }

    @Override
    public void registerServerModules(Consumer<ServerModule> registrar) {
        this.shopModule = new ServerShopModule(ServerShopModule.COMBAT_PURCHASE_HANDLER, (int)this.buyDuration.getSeconds());
        this.shopModule.addCategory(new ShopCategory((Component)new TextComponent("Rifle"), (Component)new TextComponent("Assault rifle selections."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.M4A1.get()), (Object)new ShopItem((Item)ModItems.AK47.get()), (Object)new ShopItem((Item)ModItems.FNFAL.get()), (Object)new ShopItem((Item)ModItems.ACR.get()))));
        this.shopModule.addCategory(new ShopCategory((Component)new TextComponent("SMG"), (Component)new TextComponent("Sub-machine gun selections."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.MAC10.get()), (Object)new ShopItem((Item)ModItems.P90.get()), (Object)new ShopItem((Item)ModItems.VECTOR.get()))));
        this.shopModule.addCategory(new ShopCategory((Component)new TextComponent("Heavy"), (Component)new TextComponent("Heavy-based gun selections."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.MOSSBERG.get()), (Object)new ShopItem((Item)ModItems.M240B.get()), (Object)new ShopItem((Item)ModItems.M1GARAND.get()))));
        this.shopModule.addCategory(new ShopCategory((Component)new TextComponent("Sniper"), (Component)new TextComponent("Sniper rifle selections."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.M107.get()), (Object)new ShopItem((Item)ModItems.AS50.get()), (Object)new ShopItem((Item)ModItems.AWP.get()))));
        this.shopModule.addCategory(new ShopCategory((Component)new TextComponent("Pistol"), (Component)new TextComponent("Side arm and pistol selections."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.M1911.get()), (Object)new ShopItem((Item)ModItems.G18.get()), (Object)new ShopItem((Item)ModItems.DESERT_EAGLE.get()), (Object)new ShopItem((Item)ModItems.P250.get()), (Object)new ShopItem((Item)ModItems.FN57.get()))));
        this.shopModule.addCategory(new ShopCategory((Component)new TextComponent("Grenades"), (Component)new TextComponent("Utilities and grenades."), (List<ShopItem>)ImmutableList.of((Object)new ShopItem((Item)ModItems.FLASH_GRENADE.get()), (Object)new ShopItem((Item)ModItems.DECOY_GRENADE.get()), (Object)new ShopItem((Item)ModItems.SMOKE_GRENADE.get()), (Object)new ShopItem((Item)ModItems.FIRE_GRENADE.get()), (Object)new ShopItem((Item)ModItems.FRAG_GRENADE.get()))));
        registrar.accept(this.shopModule);
        this.teamModule = new ServerTeamModule<TdmTeam>(TdmTeam.class, this);
        registrar.accept(this.teamModule);
    }

    public ServerTeamModule<TdmTeam> getTeamModule() {
        return this.teamModule;
    }

    @Override
    public boolean canChangeTeam(PlayerExtension<ServerPlayer> player, @Nullable TeamInstance<TdmTeam> oldTeam, @Nullable TeamInstance<TdmTeam> newTeam) {
        if (oldTeam != null && newTeam != null) {
            boolean tooLate;
            StateInstance<TdmServer> stateInstance = this.stateMachine.getCurrentState();
            float maxScore = (float)this.getMaxScore() * 0.75f;
            boolean scoresClose = oldTeam != null && (float)TdmTeam.getScore(oldTeam) > maxScore || (float)TdmTeam.getScore(newTeam) > maxScore;
            boolean bl = tooLate = stateInstance.getState() == TdmState.GAME && ((GameStateInstance)stateInstance).getTimeElapsedSeconds() > 240L || stateInstance.getState() == TdmState.POST_GAME;
            if (scoresClose || tooLate) {
                ((ServerPlayer)player.entity()).m_6352_(GameUtil.formatMessage(NO_SWITCH_TEAM), Util.f_137441_);
                return false;
            }
        }
        return true;
    }

    @Override
    public void teamChanged(PlayerExtension<ServerPlayer> player, @Nullable TeamInstance<TdmTeam> oldTeam, @Nullable TeamInstance<TdmTeam> newTeam) {
        if (newTeam == null) {
            ((ServerPlayer)player.entity()).m_150109_().m_6211_();
            ((ServerPlayer)player.entity()).m_143403_(GameType.SPECTATOR);
        } else {
            this.shopModule.resetBuyTime(((ServerPlayer)player.entity()).m_142081_());
            ((ServerPlayer)player.entity()).m_143403_(GameType.ADVENTURE);
            this.logicalServer.respawnPlayer((ServerPlayer)player.entity(), false);
            GameUtil.sendGameMessageToAll((Component)new TranslatableComponent("message.joined_team", new Object[]{((ServerPlayer)player.entity()).m_5446_().getString(), newTeam.getTeam().getDisplayName().getString()}), this.getMinecraftServer());
        }
    }

    @SubscribeEvent
    public void handleLivingDeath(LivingDeathEvent event) {
        if (this.getGameState() == TdmState.GAME && event.getSource().m_7639_() instanceof ServerPlayer && event.getEntityLiving() instanceof ServerPlayer && !this.firstBloodDrawn) {
            GameUtil.sendGameMessageToAll((Component)new TranslatableComponent("message.first_blood_drawn", new Object[]{event.getSource().m_7639_().m_5446_().getString()}).m_130940_(ChatFormatting.DARK_RED), this.getMinecraftServer());
            this.firstBloodDrawn = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleTriggerPressed(GunEvent.TriggerPressed event) {
        TdmPlayerHandler handler = (TdmPlayerHandler)event.living().getHandlerOrThrow(TdmPlayerHandler.TYPE);
        handler.setRemainingSpawnProtectionSeconds(0);
    }

    @SubscribeEvent
    public void handleEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)event.getEntity();
            CombatSlot.MELEE.addToInventory(((Item)ModItems.COMBAT_KNIFE.get()).m_7968_(), playerEntity.m_150109_(), false);
            this.shopModule.resetBuyTime(event.getEntity().m_142081_());
        }
    }
}

