/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.network.SynchedData;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;

public class TdmPlayerData
implements Synched {
    private static final EntityDataAccessor<Integer> SCORE = new EntityDataAccessor(0, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> KILLS = new EntityDataAccessor(1, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ASSISTS = new EntityDataAccessor(2, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DEATHS = new EntityDataAccessor(3, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DEAD = new EntityDataAccessor(4, EntityDataSerializers.f_135035_);
    private final SynchedData dataManager = new SynchedData(() -> dirtyListener.accept(this));

    public TdmPlayerData(Consumer<TdmPlayerData> dirtyListener) {
        this.dataManager.register(SCORE, (Object)0);
        this.dataManager.register(KILLS, (Object)0);
        this.dataManager.register(ASSISTS, (Object)0);
        this.dataManager.register(DEATHS, (Object)0);
        this.dataManager.register(DEAD, (Object)false);
    }

    public boolean isDead() {
        return (Boolean)this.dataManager.get(DEAD);
    }

    public void setDead(boolean dead) {
        this.dataManager.set(DEAD, (Object)dead);
    }

    public int getScore() {
        return (Integer)this.dataManager.get(SCORE);
    }

    public void incrementScore() {
        this.dataManager.compute(SCORE, score -> {
            score = score + 1;
            return score;
        });
    }

    public int getKills() {
        return (Integer)this.dataManager.get(KILLS);
    }

    public void incrementKills() {
        this.dataManager.compute(KILLS, kills -> {
            kills = kills + 1;
            return kills;
        });
    }

    public int getAssists() {
        return (Integer)this.dataManager.get(ASSISTS);
    }

    public void incrementAssists() {
        this.dataManager.compute(ASSISTS, assists -> {
            assists = assists + 1;
            return assists;
        });
    }

    public int getDeaths() {
        return (Integer)this.dataManager.get(DEATHS);
    }

    public void incrementDeaths() {
        this.dataManager.compute(DEATHS, deaths -> {
            deaths = deaths + 1;
            return deaths;
        });
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty()), (FriendlyByteBuf)out);
    }

    public void decode(FriendlyByteBuf in) {
        this.dataManager.assignValues(SynchedData.unpack((FriendlyByteBuf)in));
    }

    public boolean requiresSync() {
        return this.dataManager.isDirty();
    }
}

