/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.survival;

import com.craftingdead.immerse.server.ServerConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;

public record ThirstSettings(int decayIntervalTicks, int decayAmount, int sprintingDecayAmount, int damageIntervalTicks) {
    private static final int DECAY_INTERVAL_TICKS = 800;
    private static final int DECAY_AMOUNT = 5;
    private static final int SPRINTING_DECAY_AMOUNT = 10;
    private static final int DAMAGE_INTERVAL_TICKS = 120;
    public static final Codec<ThirstSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("decay_interval_ticks", (Object)800).forGetter(ThirstSettings::decayIntervalTicks), (App)Codec.INT.optionalFieldOf("decay_amount", (Object)5).forGetter(ThirstSettings::decayAmount), (App)Codec.INT.optionalFieldOf("sprinting_decay_amount", (Object)10).forGetter(ThirstSettings::sprintingDecayAmount), (App)Codec.INT.optionalFieldOf("damage_interval_ticks", (Object)120).forGetter(ThirstSettings::damageIntervalTicks)).apply((Applicative)instance, ThirstSettings::new));

    public int decayAmountFor(Entity entity) {
        return entity.m_20142_() ? this.sprintingDecayAmount : this.decayAmount;
    }

    public static ThirstSettings createDefault() {
        return new ThirstSettings(800, 5, 10, 120);
    }

    public static ThirstSettings fromConfig(ServerConfig config) {
        double multiplier = (Double)config.thirstDifficultyMultiplier.get();
        return new ThirstSettings((Integer)config.thirstDecayIntervalTicks.get(), (int)Math.max(1.0, (double)((Integer)config.thirstDecayAmount.get()).intValue() * multiplier), (int)Math.max(1.0, (double)((Integer)config.thirstSprintingDecayAmount.get()).intValue() * multiplier), (Integer)config.thirstDamageIntervalTicks.get());
    }
}

