/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.network;

import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.game.ClientGameWrapper;
import com.craftingdead.immerse.game.Game;
import com.craftingdead.immerse.game.GameWrapper;
import com.craftingdead.immerse.game.ServerGameWrapper;
import com.craftingdead.immerse.game.module.ModuleType;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.event.EventNetworkChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class GameNetworkChannel {
    public static final ResourceLocation CHANNEL_NAME = new ResourceLocation("craftingdeadimmerse", "game");
    private static final EventNetworkChannel channel = NetworkRegistry.newEventChannel((ResourceLocation)CHANNEL_NAME, () -> CraftingDeadImmerse.VERSION, CraftingDeadImmerse.VERSION::equals, CraftingDeadImmerse.VERSION::equals);
    private static final Logger logger = LogUtils.getLogger();
    private static boolean loaded = false;

    public static void load() {
        if (loaded) {
            throw new IllegalStateException("Game network channel already loaded");
        }
        loaded = true;
        channel.addListener(GameNetworkChannel::handleClientPayload);
        channel.addListener(GameNetworkChannel::handleServerPayload);
    }

    private static void handleClientPayload(NetworkEvent.ClientCustomPayloadEvent event) {
        ServerGameWrapper gameWrapper = CraftingDeadImmerse.getInstance().getLogicalServer().getGameWrapper();
        GameNetworkChannel.processInboundPayload(gameWrapper, event.getPayload(), (NetworkEvent.Context)event.getSource().get());
    }

    private static void handleServerPayload(NetworkEvent.ServerCustomPayloadEvent event) {
        ClientGameWrapper gameWrapper = CraftingDeadImmerse.getInstance().getClientDist().getGameWrapper();
        GameNetworkChannel.processInboundPayload(gameWrapper, event.getPayload(), (NetworkEvent.Context)event.getSource().get());
    }

    private static <MSG> void processInboundPayload(GameWrapper<?, ?> gameWrapper, FriendlyByteBuf buf, NetworkEvent.Context context) {
        try {
            if (buf.readBoolean()) {
                ModuleType moduleType = (ModuleType)buf.readRegistryIdSafe(ModuleType.class);
                Object module = gameWrapper.getModule(moduleType);
                Object message = moduleType.getNetworkProtocol().decode(buf, context);
                module.handleMessage(message, context);
            } else {
                Object message = gameWrapper.getGame().getType().getNetworkProtocol().decode(buf, context);
                gameWrapper.getGame().handleMessage(message, context);
            }
            context.setPacketHandled(true);
        }
        catch (IOException e) {
            logger.error("Failed to process server packet for '{}'", (Object)gameWrapper.getGame().getType().getRegistryName().toString());
        }
    }

    public static <MSG> void sendToServer(@Nullable ModuleType moduleType, MSG message) {
        GameNetworkChannel.sendTo(moduleType, message, Minecraft.m_91087_().m_91403_().m_6198_(), NetworkDirection.PLAY_TO_SERVER);
    }

    public static <MSG> void sendTo(@Nullable ModuleType moduleType, MSG message, Connection manager, NetworkDirection direction) {
        manager.m_129512_(GameNetworkChannel.toVanillaPacket(moduleType, message, direction));
    }

    public static <MSG> void send(@Nullable ModuleType moduleType, MSG message, PacketDistributor.PacketTarget target) {
        target.send(GameNetworkChannel.toVanillaPacket(moduleType, message, target.getDirection()));
    }

    public static <MSG> Packet<?> toVanillaPacket(@Nullable ModuleType moduleType, MSG message, NetworkDirection direction) {
        Game game = CraftingDeadImmerse.getInstance().getGame(direction.getOriginationSide());
        try {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            if (moduleType == null) {
                buf.writeBoolean(false);
                game.getType().getNetworkProtocol().encode(buf, message);
            } else {
                buf.writeBoolean(true);
                buf.writeRegistryId((IForgeRegistryEntry)moduleType);
                moduleType.getNetworkProtocol().encode(buf, message);
            }
            return direction.buildPacket(Pair.of((Object)buf, (Object)Integer.MIN_VALUE), CHANNEL_NAME).getThis();
        }
        catch (IOException e) {
            throw new EncoderException("Failed to encode game packet for '" + game.getType().getRegistryName().toString() + "'");
        }
    }
}

