/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.team;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.game.module.ServerModule;
import com.craftingdead.immerse.game.module.team.Team;
import com.craftingdead.immerse.game.module.team.TeamInstance;
import com.craftingdead.immerse.game.module.team.TeamModule;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class ServerTeamModule<T extends Enum<T>>
extends TeamModule<T>
implements ServerModule {
    private final TeamHandler<T> teamHandler;

    public ServerTeamModule(Class<T> teamType, TeamHandler<T> teamHandler) {
        super(teamType);
        this.teamHandler = teamHandler;
    }

    public void setPlayerTeam(PlayerExtension<ServerPlayer> player, @Nullable TeamInstance<T> teamInstance) {
        UUID playerId = ((ServerPlayer)player.entity()).m_142081_();
        TeamInstance oldTeamInstance = this.getPlayerTeam(playerId).map(x$0 -> this.getTeamInstance((Enum)x$0)).orElse(null);
        if ((teamInstance == null || teamInstance != oldTeamInstance) && this.teamHandler.canChangeTeam(player, oldTeamInstance, teamInstance)) {
            if (oldTeamInstance != null) {
                oldTeamInstance.removeMember(playerId);
            }
            if (teamInstance == null) {
                this.playerTeams.remove(playerId);
            } else {
                this.playerTeams.put(playerId, (Enum)teamInstance.getTeam());
                teamInstance.addMember(playerId);
            }
            this.dirtyPlayerTeams.put(playerId, teamInstance == null ? null : (Enum)teamInstance.getTeam());
            this.teamHandler.teamChanged(player, oldTeamInstance, teamInstance);
        }
    }

    public static interface TeamHandler<T extends Team> {
        public boolean canChangeTeam(PlayerExtension<ServerPlayer> var1, @Nullable TeamInstance<T> var2, @Nullable TeamInstance<T> var3);

        public void teamChanged(PlayerExtension<ServerPlayer> var1, @Nullable TeamInstance<T> var2, @Nullable TeamInstance<T> var3);
    }
}

