/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.shop;

import com.craftingdead.core.network.Synched;
import com.craftingdead.immerse.game.module.GameModule;
import com.craftingdead.immerse.game.module.ModuleType;
import com.craftingdead.immerse.game.module.ModuleTypes;
import com.craftingdead.immerse.game.module.shop.ShopCategory;
import com.craftingdead.immerse.game.module.shop.ShopItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

class ShopModule
implements GameModule,
Synched {
    protected final Map<UUID, ShopItem> items = new HashMap<UUID, ShopItem>();
    private final List<ShopCategory> categories = new ArrayList<ShopCategory>();

    ShopModule() {
    }

    public List<ShopCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public void addCategory(ShopCategory category) {
        for (ShopItem item : category.items()) {
            this.items.put(item.id(), item);
        }
        this.categories.add(category);
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
        if (writeAll) {
            out.m_130130_(this.items.size());
            this.items.values().forEach(item -> item.encode(out));
        } else {
            out.m_130130_(-1);
        }
        if (writeAll) {
            out.m_130130_(this.categories.size());
            this.categories.forEach(category -> category.encode(out));
        } else {
            out.m_130130_(-1);
        }
    }

    public void decode(FriendlyByteBuf in) {
        int categoriesSize;
        int itemsSize = in.m_130242_();
        if (itemsSize > 0) {
            this.items.clear();
            for (int i = 0; i < itemsSize; ++i) {
                ShopItem item = ShopItem.decode(in);
                this.items.put(item.id(), item);
            }
        }
        if ((categoriesSize = in.m_130242_()) > 0) {
            this.categories.clear();
            for (int i = 0; i < categoriesSize; ++i) {
                this.categories.add(ShopCategory.decode(in, this.items::get));
            }
        }
    }

    public boolean requiresSync() {
        return false;
    }

    @Override
    public ModuleType getType() {
        return (ModuleType)((Object)ModuleTypes.SHOP.get());
    }
}

