/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.shop;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.combatslot.CombatSlot;
import com.craftingdead.immerse.game.module.GameModule;
import com.craftingdead.immerse.game.module.ServerModule;
import com.craftingdead.immerse.game.module.shop.ShopItem;
import com.craftingdead.immerse.game.module.shop.ShopModule;
import com.craftingdead.immerse.game.module.shop.message.BuyItemMessage;
import com.craftingdead.immerse.game.module.shop.message.SyncUserMessage;
import com.craftingdead.immerse.game.network.GameNetworkChannel;
import com.craftingdead.immerse.game.network.MessageHandlerRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ServerShopModule
extends ShopModule
implements ServerModule,
GameModule.Tickable {
    public static final BiConsumer<PlayerExtension<?>, ItemStack> COMBAT_PURCHASE_HANDLER = (player, item) -> ((CombatSlot)CombatSlot.getSlotType((ItemStack)item).orElseThrow(() -> new IllegalStateException("Invalid item"))).addToInventory(item, ((Player)player.entity()).m_150109_(), true);
    private static final MessageHandlerRegistry<ServerShopModule> messageHandlers = new MessageHandlerRegistry();
    private final Map<UUID, ShopUser> users = new HashMap<UUID, ShopUser>();
    private final BiConsumer<PlayerExtension<?>, ItemStack> purchaseHandler;
    private final int defaultBuyTimeSeconds;
    private int secondTimer;

    public ServerShopModule(BiConsumer<PlayerExtension<?>, ItemStack> purchaseHandler, int defaultBuyTimeSeconds) {
        this.purchaseHandler = purchaseHandler;
        this.defaultBuyTimeSeconds = defaultBuyTimeSeconds;
    }

    public void buyItem(PlayerExtension<ServerPlayer> player, UUID itemId) {
        ShopItem item = (ShopItem)this.items.get(itemId);
        if (item == null) {
            throw new IllegalArgumentException("Unknown item ID: " + itemId.toString());
        }
        ShopUser user = this.users.get(((ServerPlayer)player.entity()).m_142081_());
        if (user.money >= item.price() && user.buyTimeSeconds != 0) {
            user.money -= item.price();
            user.sync();
            this.purchaseHandler.accept(player, item.itemStack());
        }
    }

    public void resetBuyTime(UUID playerId) {
        ShopUser user = this.users.get(playerId);
        if (user != null) {
            user.buyTimeSeconds = this.defaultBuyTimeSeconds;
            user.sync();
        }
    }

    private void handleBuyItem(BuyItemMessage message, NetworkEvent.Context context) {
        this.buyItem((PlayerExtension<ServerPlayer>)PlayerExtension.getOrThrow((Player)context.getSender()), message.itemId());
    }

    @Override
    public <MSG> void handleMessage(MSG message, NetworkEvent.Context context) {
        messageHandlers.handle(this, message, context);
    }

    @Override
    public void tick() {
        if (this.secondTimer++ >= 20) {
            this.secondTimer = 0;
            for (ShopUser user : this.users.values()) {
                if (user.buyTimeSeconds <= 0) continue;
                --user.buyTimeSeconds;
                user.sync();
            }
        }
    }

    @Override
    public void addPlayer(PlayerExtension<ServerPlayer> player) {
        ShopUser user = new ShopUser(((ServerPlayer)player.entity()).f_8906_.m_6198_());
        this.users.put(((ServerPlayer)player.entity()).m_142081_(), user);
        user.sync();
    }

    @Override
    public void removePlayer(PlayerExtension<ServerPlayer> player) {
        this.users.remove(((ServerPlayer)player.entity()).m_142081_());
    }

    static {
        messageHandlers.register(BuyItemMessage.class, ServerShopModule::handleBuyItem);
    }

    private class ShopUser {
        private final Connection connection;
        private int buyTimeSeconds;
        private int money;

        private ShopUser(Connection connection) {
            this.buyTimeSeconds = ServerShopModule.this.defaultBuyTimeSeconds;
            this.connection = connection;
        }

        private void sync() {
            this.connection.m_129512_(GameNetworkChannel.toVanillaPacket(ServerShopModule.this.getType(), new SyncUserMessage(this.buyTimeSeconds, this.money), NetworkDirection.PLAY_TO_CLIENT));
        }
    }
}

