/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.game.GameServer;
import com.craftingdead.immerse.game.GameWrapper;
import com.craftingdead.immerse.game.LogicalServer;
import com.craftingdead.immerse.game.PlayerRemovalReason;
import com.craftingdead.immerse.game.module.ServerModule;
import net.minecraft.server.level.ServerPlayer;

public final class ServerGameWrapper
extends GameWrapper<GameServer, ServerModule> {
    private final LogicalServer logicalServer;

    public ServerGameWrapper(GameServer game, LogicalServer logicalServer) {
        super(game);
        this.logicalServer = logicalServer;
    }

    @Override
    protected void buildModules(GameServer game, GameWrapper.ModuleBuilder<ServerModule> builder) {
        game.registerServerModules(builder::registerModule);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.requiresSync()) {
            this.logicalServer.getMinecraftServer().m_6846_().m_11268_(this.buildSyncPacket(false));
        }
    }

    public void addPlayer(PlayerExtension<ServerPlayer> player) {
        for (ServerModule module : this.modules.values()) {
            module.addPlayer(player);
        }
        ((GameServer)this.getGame()).addPlayer(player);
        ((ServerPlayer)player.entity()).f_8906_.m_141995_(this.buildSyncPacket(true));
    }

    public void removePlayer(PlayerExtension<ServerPlayer> player, PlayerRemovalReason reason) {
        ((GameServer)this.getGame()).removePlayer(player, reason);
        for (ServerModule module : this.modules.values()) {
            module.removePlayer(player);
        }
    }
}

