/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game;

import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.game.GameServer;
import com.craftingdead.immerse.game.PlayerRemovalReason;
import com.craftingdead.immerse.game.ServerGameWrapper;
import com.craftingdead.immerse.game.survival.SurvivalServer;
import com.craftingdead.immerse.game.survival.ThirstSettings;
import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.network.login.SetupGameMessage;
import com.craftingdead.immerse.network.play.AddKillFeedEntryMessage;
import com.craftingdead.immerse.network.play.ChangeGameMessage;
import com.craftingdead.immerse.server.ServerConfig;
import com.craftingdead.immerse.world.KillFeedEntry;
import com.google.common.base.Predicates;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class LogicalServer
extends SavedData {
    private static final Logger logger = LogUtils.getLogger();
    private static final Gson gson = new Gson();
    private final MinecraftServer minecraftServer;
    private static final LevelResource GAME_FOLDER_NAME = new LevelResource("games");
    private final Path gamePath;
    private ServerGameWrapper gameWrapper;
    private String currentGameName;

    public LogicalServer(MinecraftServer minecraftServer) {
        this.minecraftServer = minecraftServer;
        this.gamePath = minecraftServer.m_129843_(GAME_FOLDER_NAME);
    }

    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    public ServerGameWrapper getGameWrapper() {
        return this.gameWrapper;
    }

    public GameServer getGame() {
        return (GameServer)this.gameWrapper.getGame();
    }

    public List<Pair<String, SetupGameMessage>> generateSetupGameMessage(boolean isLocal) {
        return Collections.singletonList(Pair.of((Object)SetupGameMessage.class.getName(), (Object)new SetupGameMessage(this.getGame().getType())));
    }

    public void start() {
        this.minecraftServer.m_129880_(Level.f_46428_).m_8895_().m_164861_(this::load, () -> this, "craftingdeadimmerse");
        if (this.gameWrapper == null) {
            this.loadNextGame(true);
            if (this.gameWrapper == null) {
                throw new IllegalStateException("Game wrapper cannot be null");
            }
        }
    }

    public void stop() {
        this.gameWrapper.unload();
    }

    private void loadNextGame(boolean loadFirst) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> gameRotationConfig = CraftingDeadImmerse.serverConfig.gameRotation;
        List gameRotation = (List)gameRotationConfig.get();
        if (gameRotation.isEmpty()) {
            logger.info("Game rotation empty, defaulting to survival...");
            ServerConfig config = CraftingDeadImmerse.serverConfig;
            this.loadGame(new ServerGameWrapper(new SurvivalServer((Boolean)config.thirstEnabled.get() != false ? Optional.of(ThirstSettings.fromConfig(config)) : Optional.empty(), true), this));
            return;
        }
        String nextGameName = loadFirst || this.gameWrapper == null || this.currentGameName == null ? (String)gameRotation.get(0) : (String)gameRotation.get((gameRotation.indexOf(this.currentGameName) + 1) % gameRotation.size());
        if (!this.findAndLoadGame(nextGameName)) {
            logger.info("Removing game '{}' from game rotation", (Object)nextGameName);
            gameRotation.remove(nextGameName);
            gameRotationConfig.save();
            this.loadNextGame(false);
        }
    }

    private boolean findAndLoadGame(String gameName) {
        GameServer gameServer;
        File gameFile = new File(this.gamePath.toFile(), gameName + ".json");
        if (!gameFile.exists()) {
            logger.error("Game file with name '{}' does not exist");
            return false;
        }
        try (FileReader fileReader = new FileReader(gameFile);){
            gameServer = (GameServer)GameServer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)gson.fromJson((Reader)fileReader, JsonElement.class))).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0));
        }
        catch (Throwable t) {
            logger.error("Failed to load game file '{}'", (Object)gameFile.toString(), (Object)t);
            return false;
        }
        this.loadGame(new ServerGameWrapper(gameServer, this));
        this.currentGameName = gameName;
        return true;
    }

    private void loadGame(ServerGameWrapper gameWrapper) {
        List players = this.minecraftServer.m_6846_().m_11314_();
        ServerGameWrapper oldGameWrapper = this.gameWrapper;
        if (oldGameWrapper != null) {
            logger.info("Unloading current game");
            players.stream().map(PlayerExtension::getOrThrow).forEach(player -> oldGameWrapper.removePlayer((PlayerExtension<ServerPlayer>)player, PlayerRemovalReason.GAME_UNLOADED));
            oldGameWrapper.unload();
        }
        logger.info("Loading game type '{}'", (Object)((GameServer)gameWrapper.getGame()).getType().getRegistryName().toString());
        this.gameWrapper = gameWrapper;
        gameWrapper.load();
        logger.info("Loading players");
        for (ServerPlayer player2 : players) {
            player2.f_8906_.m_141995_(NetworkChannel.PLAY.getSimpleChannel().toVanillaPacket((Object)new ChangeGameMessage(((GameServer)gameWrapper.getGame()).getType()), NetworkDirection.PLAY_TO_CLIENT));
            if (oldGameWrapper != null && ((GameServer)gameWrapper.getGame()).persistPlayerData() && !((GameServer)oldGameWrapper.getGame()).persistPlayerData()) {
                this.minecraftServer.m_6846_().m_11224_(player2);
            }
            gameWrapper.addPlayer((PlayerExtension<ServerPlayer>)PlayerExtension.getOrThrow((Player)player2));
        }
        logger.info("Respawning players");
        this.respawnPlayers(((GameServer)gameWrapper.getGame()).persistPlayerData());
    }

    public void reloadGameRotation() {
        this.loadNextGame(true);
    }

    public void restartGame() {
        this.loadGame(this.gameWrapper);
    }

    public void respawnPlayers(boolean keepData) {
        this.respawnPlayers((Predicate<ServerPlayer>)Predicates.alwaysTrue(), keepData);
    }

    public void respawnPlayers(Predicate<ServerPlayer> predicate, boolean keepData) {
        List<ServerPlayer> players = List.copyOf(this.minecraftServer.m_6846_().m_11314_());
        for (ServerPlayer playerEntity : players) {
            if (!predicate.test(playerEntity)) continue;
            this.respawnPlayer(playerEntity, keepData);
        }
    }

    public void respawnPlayer(ServerPlayer playerEntity, boolean keepData) {
        playerEntity.f_8906_.f_9743_ = this.minecraftServer.m_6846_().m_11236_(playerEntity, keepData);
    }

    public LogicalServer load(CompoundTag tag) {
        CompoundTag gameTag = tag.m_128469_("game");
        if (!gameTag.m_128456_()) {
            GameServer gameServer = (GameServer)GameServer.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)gameTag).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0));
            this.loadGame(new ServerGameWrapper(gameServer, this));
        }
        return this;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        if (this.getGame().persistGameData()) {
            tag.m_128365_("game", (Tag)GameServer.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.getGame()).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)));
        }
        return tag;
    }

    @SubscribeEvent
    public void handleServerTick(TickEvent.ServerTickEvent event) {
        switch (event.phase) {
            case START: {
                this.gameWrapper.tick();
                if (!this.getGame().isFinished()) break;
                this.loadNextGame(false);
                break;
            }
        }
    }

    @SubscribeEvent
    public void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        this.gameWrapper.addPlayer((PlayerExtension<ServerPlayer>)PlayerExtension.getOrThrow((Player)player));
    }

    @SubscribeEvent
    public void handlePlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        player.reviveCaps();
        this.gameWrapper.removePlayer((PlayerExtension<ServerPlayer>)PlayerExtension.getOrThrow((Player)player), PlayerRemovalReason.LOGGED_OUT);
        player.invalidateCaps();
    }

    @SubscribeEvent
    public void handleGunHitEntity(GunEvent.EntityDamaged event) {
        Player player;
        Entity entity;
        if (!event.living().level().m_5776_() && ((GameServer)this.gameWrapper.getGame()).killFeedEnabled() && (entity = event.target()) instanceof Player && (player = (Player)entity).m_21224_()) {
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.ALL.noArg(), (Object)new AddKillFeedEntryMessage(new KillFeedEntry(event.living().entity(), event.target(), event.getItemStack(), event.headshot() ? KillFeedEntry.Type.HEADSHOT : KillFeedEntry.Type.NONE)));
        }
    }
}

