/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game;

import com.craftingdead.immerse.game.GameClient;
import com.craftingdead.immerse.game.GameServer;
import com.craftingdead.immerse.game.GameTypes;
import com.craftingdead.immerse.game.network.NetworkProtocol;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GameType
extends ForgeRegistryEntry<GameType> {
    public static final Codec<GameType> CODEC = ExtraCodecs.m_184415_(() -> GameTypes.registry.get().getCodec());
    private final Codec<? extends GameServer> gameServerCodec;
    private final Supplier<DistExecutor.SafeCallable<GameClient>> gameClientFactory;
    private final NetworkProtocol networkProtocol;

    public GameType(Codec<? extends GameServer> gameServerCodec, Supplier<DistExecutor.SafeCallable<GameClient>> gameClientFactory, NetworkProtocol networkProtocol) {
        this.gameServerCodec = gameServerCodec;
        this.gameClientFactory = gameClientFactory;
        this.networkProtocol = networkProtocol;
    }

    public Codec<? extends GameServer> getGameServerCodec() {
        return this.gameServerCodec;
    }

    public GameClient createGameClient() {
        GameClient gameClient = (GameClient)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, this.gameClientFactory);
        if (gameClient == null) {
            throw new IllegalStateException("Attempting to create game client on a server!");
        }
        return gameClient;
    }

    public NetworkProtocol getNetworkProtocol() {
        return this.networkProtocol;
    }

    public Component getDisplayName() {
        return new TranslatableComponent(Util.m_137492_((String)"game", (ResourceLocation)this.getRegistryName()));
    }
}

