/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.game.Game;
import com.craftingdead.immerse.game.GameType;
import com.craftingdead.immerse.game.PlayerRemovalReason;
import com.craftingdead.immerse.game.module.ServerModule;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerPlayer;

public interface GameServer
extends Game {
    public static final Codec<GameServer> CODEC = GameType.CODEC.dispatch(Game::getType, GameType::getGameServerCodec);

    default public void registerServerModules(Consumer<ServerModule> consumer) {
    }

    default public void addPlayer(PlayerExtension<ServerPlayer> player) {
    }

    default public void removePlayer(PlayerExtension<ServerPlayer> player, PlayerRemovalReason reason) {
    }

    public boolean isFinished();

    public boolean persistPlayerData();

    default public Optional<GlobalPos> getSpawnPoint(PlayerExtension<ServerPlayer> player) {
        return Optional.empty();
    }

    public boolean persistGameData();

    default public boolean killFeedEnabled() {
        return true;
    }
}

