/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class RenderUtil {
    private static Minecraft minecraft;

    private static Minecraft getMinecraft() {
        if (minecraft == null) {
            minecraft = Minecraft.m_91087_();
        }
        return minecraft;
    }

    public static void registerSvgTexture(ResourceLocation resourceLocation) {
        try {
            InputStream inputStream = RenderUtil.getMinecraft().m_91098_().m_142591_(resourceLocation).m_6679_();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void renderTextRight(Font fontRenderer, PoseStack poseStack, float x, float y, Component text, int colour, boolean shadow) {
        if (shadow) {
            fontRenderer.m_92763_(poseStack, text, x - (float)fontRenderer.m_92852_((FormattedText)text), y, colour);
        } else {
            fontRenderer.m_92889_(poseStack, text, x - (float)fontRenderer.m_92852_((FormattedText)text), y, colour);
        }
    }

    public static void renderTextRight(Font fontRenderer, PoseStack poseStack, float x, float y, String text, int colour, boolean shadow) {
        fontRenderer.m_92756_(poseStack, text, x - (float)fontRenderer.m_92895_(text), y, colour, shadow);
    }

    public static void fillWithShadow(PoseStack poseStack, float x, float y, float width, float height, int colour) {
        RenderUtil.fill(poseStack, x - 1.0f, y - 1.0f, x + width + 1.0f, y + height + 1.0f, 0x4D000000L);
        RenderUtil.fill(poseStack, x, y, x + width, y + height, colour);
    }

    public static void fillWidthHeight(PoseStack poseStack, float x, float y, float width, float height, int colour) {
        RenderUtil.fill(poseStack, x, y, x + width, y + height, colour);
    }

    public static void fill(PoseStack poseStack, float x, float y, float x2, float y2, long colour) {
        RenderUtil.fill(poseStack, x, y, 0.0f, x2, y2, colour);
    }

    public static void fill(PoseStack poseStack, float x, float y, float z, float x2, float y2, long colour) {
        float alpha = (float)(colour >> 24 & 0xFFL) / 255.0f;
        float red = (float)(colour >> 16 & 0xFFL) / 255.0f;
        float green = (float)(colour >> 8 & 0xFFL) / 255.0f;
        float blue = (float)(colour & 0xFFL) / 255.0f;
        RenderUtil.fill(poseStack.m_85850_().m_85861_(), x, y, z, x2, y2, red, green, blue, alpha);
    }

    public static void fill(Matrix4f matrix, float x, float y, float z, float x2, float y2, float red, float green, float blue, float alpha) {
        if (x < x2) {
            float i = x;
            x = x2;
            x2 = i;
        }
        if (y < y2) {
            float j = y;
            y = y2;
            y2 = j;
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_85982_(matrix, x, y2, z).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, x2, y2, z).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, x2, y, z).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, x, y, z).m_85950_(red, green, blue, alpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public static void blit(PoseStack poseStack, float x, float y, float width, float height) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderUtil.blit(poseStack.m_85850_().m_85861_(), x, y, x + width, y + height, 0.0f, 1.0f, 1.0f, 0.0f);
    }

    public static void blit(PoseStack poseStack, float x, float y, float x2, float y2, float textureX, float textureY, float textureX2, float textureY2, float width, float height) {
        float u = textureX / width;
        float u2 = textureX2 / width;
        float v = textureY / height;
        float v2 = textureY2 / height;
        RenderUtil.blit(poseStack.m_85850_().m_85861_(), x, y, x2, y2, u, v, u2, v2);
    }

    public static void blit(Matrix4f matrix, float x, float y, float x2, float y2, float u, float v, float u2, float v2) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_85982_(matrix, x, y2, 0.0f).m_7421_(u, v).m_5752_();
        builder.m_85982_(matrix, x2, y2, 0.0f).m_7421_(u2, v).m_5752_();
        builder.m_85982_(matrix, x2, y, 0.0f).m_7421_(u2, v2).m_5752_();
        builder.m_85982_(matrix, x, y, 0.0f).m_7421_(u, v2).m_5752_();
        tesselator.m_85914_();
    }

    public static void blitAvatar(ResourceLocation skin, PoseStack poseStack, float x, float y, float width, float height) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)skin);
        RenderUtil.spriteBlit(poseStack, x, y, width, height, 8.0f, 8.0f, 8.0f, 8.0f, 64.0f, 64.0f);
    }

    public static void spriteBlit(PoseStack poseStack, float x, float y, float width, float height, float spriteX, float spriteY, float spriteWidth, float spriteHeight, float textureWidth, float textureHeight) {
        RenderUtil.spriteBlit(poseStack, x, y, x + width, y + height, 0.0f, spriteWidth, spriteHeight, spriteX, spriteY, textureWidth, textureHeight);
    }

    public static void spriteBlit(PoseStack poseStack, float x, float y, float x2, float y2, float z, float spriteWidth, float spriteHeight, float spriteX, float spriteY, float textureWidth, float textureHeight) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderUtil.blit(poseStack.m_85850_().m_85861_(), x, y, x2, y2, spriteX / textureWidth, (spriteY + spriteHeight) / textureHeight, (spriteX + spriteWidth) / textureWidth, spriteY / textureHeight);
    }

    public static void renderPlayerListRow(PoseStack poseStack, int x, int y, int width, int height, Component ping, Component username, Component ... stats) {
        int statWidth = 31;
        int pingWidth = 26;
        boolean columnSpacing = true;
        Objects.requireNonNull(RenderUtil.getMinecraft().f_91062_);
        int textYOffset = 1 + (height - 9) / 2;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderUtil.fillWidthHeight(poseStack, x, y, 26.0f, height, -1275068416);
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)RenderUtil.getMinecraft().f_91062_, (Component)ping, (int)(x + 13), (int)(y + textYOffset), (int)-1);
        int usernameColumnWidth = width - 26 - 1 - stats.length * 31;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderUtil.fillWidthHeight(poseStack, x + 26 + 1, y, usernameColumnWidth, height, -1275068416);
        RenderUtil.getMinecraft().f_91062_.m_92763_(poseStack, username, (float)(x + 54), (float)(y + textYOffset), -1);
        int statsX = x + 26 - 8 + usernameColumnWidth;
        for (int i = 0; i < stats.length; ++i) {
            Component stat = stats[i];
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderUtil.fillWidthHeight(poseStack, statsX + 10 + i * 31, y, 30.0f, height, -1275068416);
            GuiComponent.m_93215_((PoseStack)poseStack, (Font)RenderUtil.getMinecraft().f_91062_, (Component)stat, (int)(statsX + 10 + i * 31 + 16), (int)(y + textYOffset), (int)-1);
        }
    }
}

