/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.renderer;

import com.craftingdead.immerse.mixin.ItemInHandRendererAccessor;
import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraftforge.client.ForgeHooksClient;

public class SpectatorRenderer {
    private Minecraft minecraft;
    private float prevEquippedProgressMainHand;
    private float equippedProgressMainHand;
    private float prevEquippedProgressOffHand;
    private float equippedProgressOffHand;
    private ItemStack itemStackOffHand = null;
    private ItemStack itemStackMainHand = null;

    private Minecraft getMinecraft() {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.m_91087_();
        }
        return this.minecraft;
    }

    public void renderItemInFirstPerson(float partialTicks, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, AbstractClientPlayer playerEntity, int packetLight) {
        float leftHandSwingProgress;
        float equippedProgress;
        float rightHandSwingProgress;
        float swingProgress = playerEntity.m_21324_(partialTicks);
        InteractionHand hand = (InteractionHand)MoreObjects.firstNonNull((Object)playerEntity.f_20912_, (Object)InteractionHand.MAIN_HAND);
        float rotationPitch = Mth.m_14179_((float)partialTicks, (float)playerEntity.f_19860_, (float)playerEntity.m_146909_());
        ItemStack heldStack = playerEntity.m_21205_();
        ItemStack offStack = playerEntity.m_21206_();
        boolean renderRightHand = true;
        boolean renderLeftHand = true;
        if (playerEntity.m_6117_()) {
            InteractionHand activeHand;
            ItemStack itemstack = playerEntity.m_21211_();
            if (itemstack.m_41720_() instanceof ProjectileWeaponItem) {
                renderRightHand = playerEntity.m_7655_() == InteractionHand.MAIN_HAND;
                boolean bl = renderLeftHand = !renderRightHand;
            }
            if ((activeHand = playerEntity.m_7655_()) == InteractionHand.MAIN_HAND && offStack.m_41720_() == Items.f_42717_ && CrossbowItem.m_40932_((ItemStack)offStack)) {
                renderLeftHand = false;
            }
        } else {
            if (heldStack.m_41720_() == Items.f_42717_ && CrossbowItem.m_40932_((ItemStack)heldStack)) {
                boolean bl = renderLeftHand = !renderRightHand;
            }
            if (offStack.m_41720_() == Items.f_42717_ && CrossbowItem.m_40932_((ItemStack)offStack)) {
                renderRightHand = !heldStack.m_41619_();
                renderLeftHand = !renderRightHand;
            }
        }
        ItemInHandRendererAccessor firstPersonRenderer = (ItemInHandRendererAccessor)this.getMinecraft().m_91292_();
        if (renderRightHand && !ForgeHooksClient.renderSpecificFirstPersonHand((InteractionHand)InteractionHand.MAIN_HAND, (PoseStack)matrixStack, (MultiBufferSource)renderTypeBuffer, (int)packetLight, (float)partialTicks, (float)rotationPitch, (float)(rightHandSwingProgress = hand == InteractionHand.MAIN_HAND ? swingProgress : 0.0f), (float)(equippedProgress = 1.0f - Mth.m_14179_((float)partialTicks, (float)this.prevEquippedProgressMainHand, (float)this.equippedProgressMainHand)), (ItemStack)this.itemStackMainHand)) {
            firstPersonRenderer.invokeRenderArmWithItem(playerEntity, partialTicks, rotationPitch, InteractionHand.MAIN_HAND, rightHandSwingProgress, this.itemStackMainHand, equippedProgress, matrixStack, (MultiBufferSource)renderTypeBuffer, packetLight);
        }
        if (renderLeftHand && !ForgeHooksClient.renderSpecificFirstPersonHand((InteractionHand)InteractionHand.OFF_HAND, (PoseStack)matrixStack, (MultiBufferSource)renderTypeBuffer, (int)packetLight, (float)partialTicks, (float)rotationPitch, (float)(leftHandSwingProgress = hand == InteractionHand.OFF_HAND ? swingProgress : 0.0f), (float)(equippedProgress = 1.0f - Mth.m_14179_((float)partialTicks, (float)this.prevEquippedProgressOffHand, (float)this.equippedProgressOffHand)), (ItemStack)this.itemStackOffHand)) {
            firstPersonRenderer.invokeRenderArmWithItem(playerEntity, partialTicks, rotationPitch, InteractionHand.OFF_HAND, leftHandSwingProgress, this.itemStackOffHand, equippedProgress, matrixStack, (MultiBufferSource)renderTypeBuffer, packetLight);
        }
        renderTypeBuffer.m_109911_();
    }

    public void tick(AbstractClientPlayer playerEntity) {
        this.prevEquippedProgressMainHand = this.equippedProgressMainHand;
        this.prevEquippedProgressOffHand = this.equippedProgressOffHand;
        ItemStack heldStack = playerEntity.m_21205_();
        ItemStack offStack = playerEntity.m_21206_();
        if (ItemStack.m_41728_((ItemStack)this.itemStackMainHand, (ItemStack)heldStack)) {
            this.itemStackMainHand = heldStack;
        }
        if (ItemStack.m_41728_((ItemStack)this.itemStackOffHand, (ItemStack)offStack)) {
            this.itemStackOffHand = offStack;
        }
        float cooledAttackStrength = playerEntity.m_36403_(1.0f);
        boolean requipMainHand = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.itemStackMainHand, (ItemStack)heldStack, (int)playerEntity.m_150109_().f_35977_);
        boolean requipOffHand = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.itemStackOffHand, (ItemStack)offStack, (int)-1);
        if (!requipMainHand && this.itemStackMainHand != heldStack) {
            this.itemStackMainHand = heldStack;
        }
        if (!requipOffHand && this.itemStackOffHand != offStack) {
            this.itemStackOffHand = offStack;
        }
        this.equippedProgressMainHand += Mth.m_14036_((float)((!requipMainHand ? cooledAttackStrength * cooledAttackStrength * cooledAttackStrength : 0.0f) - this.equippedProgressMainHand), (float)-0.4f, (float)0.4f);
        this.equippedProgressOffHand += Mth.m_14036_((float)((float)(!requipOffHand ? 1 : 0) - this.equippedProgressOffHand), (float)-0.4f, (float)0.4f);
        if (this.equippedProgressMainHand < 0.1f) {
            this.itemStackMainHand = heldStack;
        }
        if (this.equippedProgressOffHand < 0.1f) {
            this.itemStackOffHand = offStack;
        }
    }
}

