/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.renderer;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.util.BlockUtil;
import com.craftingdead.immerse.world.action.BuildAction;
import com.craftingdead.immerse.world.action.BuildDoorWallAction;
import com.craftingdead.immerse.world.item.BlueprintItem;
import com.craftingdead.immerse.world.item.ImmerseItems;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlueprintOutlineRenderer {
    private static final Set<BlockPos> WALL = BlueprintOutlineRenderer.createWallPositions();
    private static final Set<BlockPos> DOOR_WALL = BuildDoorWallAction.WALL_OFFSETS;
    private static final Set<BlockPos> BLOCK = Set.of(new BlockPos(0, 0, 0));
    private static final Set<BlockPos> PLATFORM = BlueprintOutlineRenderer.createPlatformPositions();
    private Map<Item, Set<BlockPos>> blueprintOutlines;
    private BlueprintItem lastItem;
    private BlockPos lastPos;
    private BlockPos blockPos;
    private boolean valid;

    private static Set<BlockPos> createWallPositions() {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = 0; z <= 0; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        return Set.copyOf(positions);
    }

    private static Set<BlockPos> createPlatformPositions() {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 0; ++y) {
                for (int z = 0; z <= 2; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        return Set.copyOf(positions);
    }

    public void register() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)((Item)ImmerseItems.BASE_CENTER_BLUEPRINT.get()), BLOCK);
        builder.put((Object)((Item)ImmerseItems.CAMPFIRE_BLUEPRINT.get()), BLOCK);
        builder.put((Object)((Item)ImmerseItems.CHEST_BLUEPRINT.get()), BLOCK);
        builder.put((Object)((Item)ImmerseItems.OAK_PLANK_WALL_BLUEPRINT.get()), WALL);
        builder.put((Object)((Item)ImmerseItems.SPRUCE_PLANK_WALL_BLUEPRINT.get()), WALL);
        builder.put((Object)((Item)ImmerseItems.BIRCH_PLANK_WALL_BLUEPRINT.get()), WALL);
        builder.put((Object)((Item)ImmerseItems.JUNGLE_PLANK_WALL_BLUEPRINT.get()), WALL);
        builder.put((Object)((Item)ImmerseItems.ACACIA_PLANK_WALL_BLUEPRINT.get()), WALL);
        builder.put((Object)((Item)ImmerseItems.DARK_OAK_PLANK_WALL_BLUEPRINT.get()), WALL);
        builder.put((Object)((Item)ImmerseItems.OAK_DOOR_BLUEPRINT.get()), DOOR_WALL);
        builder.put((Object)((Item)ImmerseItems.SPRUCE_DOOR_BLUEPRINT.get()), DOOR_WALL);
        builder.put((Object)((Item)ImmerseItems.BIRCH_DOOR_BLUEPRINT.get()), DOOR_WALL);
        builder.put((Object)((Item)ImmerseItems.JUNGLE_DOOR_BLUEPRINT.get()), DOOR_WALL);
        builder.put((Object)((Item)ImmerseItems.ACACIA_DOOR_BLUEPRINT.get()), DOOR_WALL);
        builder.put((Object)((Item)ImmerseItems.DARK_OAK_DOOR_BLUEPRINT.get()), DOOR_WALL);
        builder.put((Object)((Item)ImmerseItems.OAK_PLANK_PLATFORM_BLUEPRINT.get()), PLATFORM);
        builder.put((Object)((Item)ImmerseItems.SPRUCE_PLANK_PLATFORM_BLUEPRINT.get()), PLATFORM);
        builder.put((Object)((Item)ImmerseItems.BIRCH_PLANK_PLATFORM_BLUEPRINT.get()), PLATFORM);
        builder.put((Object)((Item)ImmerseItems.JUNGLE_PLANK_PLATFORM_BLUEPRINT.get()), PLATFORM);
        builder.put((Object)((Item)ImmerseItems.ACACIA_PLANK_PLATFORM_BLUEPRINT.get()), PLATFORM);
        builder.put((Object)((Item)ImmerseItems.DARK_OAK_PLANK_PLATFORM_BLUEPRINT.get()), PLATFORM);
        this.blueprintOutlines = builder.buildOrThrow();
    }

    private boolean validate(PlayerExtension<AbstractClientPlayer> player, BlueprintItem item, BlockHitResult hitResult) {
        return item.getActionType().createBlockAction(player, new UseOnContext((Player)player.entity(), InteractionHand.MAIN_HAND, hitResult)).map(action -> action.start(true)).orElse(false);
    }

    public void render(PlayerExtension<AbstractClientPlayer> player, BlueprintItem item, BlockHitResult hitResult, Camera camera, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockPos blockPos = this.blockPos;
        boolean valid = this.valid;
        Object var10_9 = player.getAction().orElse(null);
        if (var10_9 instanceof BuildAction) {
            BuildAction action = var10_9;
            blockPos = action.getContext().m_8083_();
            valid = true;
        } else if (item != this.lastItem || !hitResult.m_82425_().equals((Object)this.lastPos)) {
            this.lastItem = item;
            this.lastPos = hitResult.m_82425_();
            valid = this.valid = this.validate(player, item, hitResult);
            BlockPlaceContext context = new BlockPlaceContext((Player)player.entity(), InteractionHand.MAIN_HAND, player.mainHandItem(), hitResult);
            blockPos = this.blockPos = context.m_8083_();
        }
        Rotation rotation = BlockUtil.getRotation(((AbstractClientPlayer)player.entity()).m_6350_());
        Vec3 position = camera.m_90583_();
        Set<BlockPos> outlines = this.blueprintOutlines.get((Object)item);
        if (outlines == null) {
            return;
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        for (BlockPos shape : outlines) {
            shape = shape.m_7954_(rotation);
            double minX = (double)(blockPos.m_123341_() + shape.m_123341_()) - position.m_7096_();
            double minY = (double)(blockPos.m_123342_() + shape.m_123342_()) - position.m_7098_();
            double minZ = (double)(blockPos.m_123343_() + shape.m_123343_()) - position.m_7094_();
            double maxX = minX + 1.0;
            double maxY = minY + 1.0;
            double maxZ = minZ + 1.0;
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)1.0f, (float)(valid ? 1.0f : 0.0f), (float)(valid ? 1.0f : 0.0f), (float)0.5f);
        }
    }
}

