/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.world;

import com.craftingdead.immerse.client.gui.screen.menu.play.list.world.WorldListView;
import com.mojang.logging.LogUtils;
import io.github.humbleui.skija.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.WorldStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import sm0keysa1m0n.bliss.view.ImageAccess;
import sm0keysa1m0n.bliss.view.ImageView;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.ViewScreen;
import sm0keysa1m0n.bliss.view.event.ActionEvent;

class WorldItemView
extends ParentView {
    private static final Logger logger = LogUtils.getLogger();
    private static final DateFormat dateFormat = new SimpleDateFormat();
    private static final ResourceLocation UNKOWN_SERVER_ICON = new ResourceLocation("textures/misc/unknown_server.png");
    private final LevelSummary worldSummary;
    private final WorldListView parentWorldList;
    private Image iconImage;

    WorldItemView(LevelSummary levelSummary, WorldListView parentWorldList) {
        super(new View.Properties().styleClasses("item").doubleClick(true).focusable(true));
        this.worldSummary = levelSummary;
        this.parentWorldList = parentWorldList;
        this.iconImage = this.loadIconTexture(levelSummary);
        if (this.iconImage == null) {
            try (InputStream inputStream = this.minecraft.m_91098_().m_142591_(UNKOWN_SERVER_ICON).m_6679_();){
                this.iconImage = Image.makeFromEncoded((byte[])inputStream.readAllBytes());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.eventBus().subscribe(ActionEvent.class, __ -> this.joinWorld());
        this.addChild(new ImageView(new View.Properties().id("icon")).setImage(ImageAccess.forImage(this.iconImage)));
        ParentView texts = new ParentView(new View.Properties().id("texts"));
        texts.addChild(new TextView(new View.Properties()).setText(levelSummary.m_78361_()));
        texts.addChild(new TextView(new View.Properties().id("details")).setText((FormattedText)new TextComponent(levelSummary.m_78358_() + " (" + dateFormat.format(new Date(levelSummary.m_78366_())) + ")").m_130940_(ChatFormatting.GRAY)));
        texts.addChild(new TextView(new View.Properties()).setText((FormattedText)levelSummary.m_78376_().m_6881_().m_130940_(ChatFormatting.GRAY)));
        this.addChild(texts);
    }

    @Override
    public void keyPressed(int keyCode, int scanCode, int modifiers) {
        super.keyPressed(keyCode, scanCode, modifiers);
        if (keyCode == 32 && this.isFocused()) {
            this.parentWorldList.setSelectedItem(this);
        }
    }

    @Override
    public boolean mousePressed(double mouseX, double mouseY, int button) {
        if (this.isFocused()) {
            this.parentWorldList.setSelectedItem(this);
        }
        return super.mousePressed(mouseX, mouseY, button);
    }

    @Nullable
    private Image loadIconTexture(LevelSummary levelSummary) {
        Image image;
        File iconFile = levelSummary.m_78362_();
        if (!iconFile.isFile()) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(iconFile);
        try {
            Image image2 = Image.makeFromEncoded((byte[])((InputStream)inputStream).readAllBytes());
            Validate.validState((image2.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
            Validate.validState((image2.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
            image = image2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                logger.error("Invalid icon for world {}", (Object)levelSummary.m_78358_(), (Object)throwable3);
                return null;
            }
        }
        ((InputStream)inputStream).close();
        return image;
    }

    public void joinWorld() {
        if (this.worldSummary.m_164916_()) {
            return;
        }
        ViewScreen screen = this.getScreen();
        LevelSummary.BackupStatus backupStatus = this.worldSummary.m_164914_();
        if (backupStatus.m_164931_()) {
            String backupQuestionKey = "selectWorld.backupQuestion." + backupStatus.m_164933_();
            String backupWarningKey = "selectWorld.backupWarning." + backupStatus.m_164933_();
            TranslatableComponent backupQuestion = new TranslatableComponent(backupQuestionKey);
            if (backupStatus.m_164932_()) {
                backupQuestion.m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED});
            }
            TranslatableComponent backupWarning = new TranslatableComponent(backupWarningKey, new Object[]{this.worldSummary.m_78370_(), SharedConstants.m_183709_().getName()});
            screen.keepOpenAndSetScreen((Screen)new BackupConfirmScreen((Screen)screen, (backup, eraseCache) -> {
                if (backup) {
                    String levelName = this.worldSummary.m_78361_();
                    try (LevelStorageSource.LevelStorageAccess levelSave = this.minecraft.m_91392_().m_78260_(levelName);){
                        EditWorldScreen.m_101258_((LevelStorageSource.LevelStorageAccess)levelSave);
                    }
                    catch (IOException ioexception) {
                        SystemToast.m_94852_((Minecraft)this.minecraft, (String)levelName);
                        logger.error("Failed to backup level {}", (Object)levelName, (Object)ioexception);
                    }
                }
                this.loadWorld();
                screen.m_7861_();
            }, (Component)backupQuestion, (Component)backupWarning, false));
        } else if (this.worldSummary.m_78373_()) {
            screen.keepOpenAndSetScreen((Screen)new ConfirmScreen(confirm -> {
                if (confirm) {
                    try {
                        this.loadWorld();
                        screen.m_7861_();
                    }
                    catch (Exception exception) {
                        logger.error("Failure to open 'future world'", (Throwable)exception);
                        this.minecraft.m_91152_((Screen)new AlertScreen(() -> this.minecraft.m_91152_(this.minecraft.f_91080_), (Component)new TranslatableComponent("selectWorld.futureworld.error.title"), (Component)new TranslatableComponent("selectWorld.futureworld.error.text")));
                    }
                } else {
                    this.minecraft.m_91152_((Screen)screen);
                }
            }, (Component)new TranslatableComponent("selectWorld.versionQuestion"), (Component)new TranslatableComponent("selectWorld.versionWarning", new Object[]{this.worldSummary.m_78370_(), new TranslatableComponent("selectWorld.versionJoinButton"), CommonComponents.f_130656_})));
        } else {
            this.loadWorld();
        }
    }

    private void loadWorld() {
        if (this.minecraft.m_91392_().m_78255_(this.worldSummary.m_78361_())) {
            this.minecraft.m_91346_((Screen)new GenericDirtMessageScreen((Component)new TranslatableComponent("selectWorld.data_read")));
            this.minecraft.m_91200_(this.worldSummary.m_78358_());
        }
    }

    public void editWorld() {
        String fileName = this.worldSummary.m_78361_();
        try {
            LevelStorageSource.LevelStorageAccess levelSave = this.minecraft.m_91392_().m_78260_(fileName);
            ViewScreen screen = this.getScreen();
            screen.keepOpenAndSetScreen((Screen)new EditWorldScreen(confirm -> {
                try {
                    levelSave.close();
                }
                catch (IOException ioexception1) {
                    logger.error("Failed to unlock level {}", (Object)fileName, (Object)ioexception1);
                }
                if (confirm) {
                    this.parentWorldList.reloadWorlds();
                }
                this.minecraft.m_91152_((Screen)screen);
            }, levelSave));
        }
        catch (IOException ioexception) {
            SystemToast.m_94852_((Minecraft)this.minecraft, (String)fileName);
            logger.error("Failed to access level {}", (Object)fileName, (Object)ioexception);
            this.parentWorldList.reloadWorlds();
        }
    }

    public void deleteWorld() {
        ViewScreen screen = this.getScreen();
        screen.keepOpenAndSetScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                this.minecraft.m_91152_((Screen)new ProgressScreen(true));
                LevelStorageSource levelSource = this.minecraft.m_91392_();
                String s = this.worldSummary.m_78361_();
                try (LevelStorageSource.LevelStorageAccess levelSave = levelSource.m_78260_(s);){
                    levelSave.m_78311_();
                }
                catch (IOException ioexception) {
                    SystemToast.m_94866_((Minecraft)this.minecraft, (String)s);
                    logger.error("Failed to delete world {}", (Object)s, (Object)ioexception);
                }
                this.parentWorldList.reloadWorlds();
            }
            this.minecraft.m_91152_((Screen)screen);
        }, (Component)new TranslatableComponent("selectWorld.deleteQuestion"), (Component)new TranslatableComponent("selectWorld.deleteWarning", new Object[]{this.worldSummary.m_78361_()}), (Component)new TranslatableComponent("selectWorld.deleteButton"), CommonComponents.f_130656_));
    }

    public void recreateWorld() {
        ViewScreen screen = this.getScreen();
        screen.keepOpen();
        this.minecraft.m_91346_((Screen)new GenericDirtMessageScreen((Component)new TranslatableComponent("selectWorld.data_read")));
        try (LevelStorageSource.LevelStorageAccess levelSave = this.minecraft.m_91392_().m_78260_(this.worldSummary.m_78361_());
             WorldStem worldStem = this.minecraft.m_205152_(levelSave, false);){
            WorldGenSettings worldGenSettings = worldStem.f_206895_().m_5961_();
            Path path = CreateWorldScreen.m_100906_((Path)levelSave.m_78283_(LevelResource.f_78180_), (Minecraft)this.minecraft);
            if (worldGenSettings.m_64670_()) {
                this.minecraft.m_91152_((Screen)new ConfirmScreen(confirm -> this.minecraft.m_91152_((Screen)(confirm ? CreateWorldScreen.m_205426_((Screen)screen, (WorldStem)worldStem, (Path)path) : screen)), (Component)new TranslatableComponent("selectWorld.recreate.customized.title"), (Component)new TranslatableComponent("selectWorld.recreate.customized.text"), CommonComponents.f_130659_, CommonComponents.f_130656_));
            } else {
                this.minecraft.m_91152_((Screen)CreateWorldScreen.m_205426_((Screen)screen, (WorldStem)worldStem, (Path)path));
            }
        }
        catch (Exception e) {
            logger.error("Unable to recreate world", (Throwable)e);
            this.minecraft.m_91152_((Screen)new AlertScreen(() -> this.minecraft.m_91152_((Screen)screen), (Component)new TranslatableComponent("selectWorld.recreate.error.title"), (Component)new TranslatableComponent("selectWorld.recreate.error.text")));
        }
    }
}

