/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.server;

import com.craftingdead.immerse.client.gui.screen.Theme;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerEntry;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerItemView;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerList;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerStatusProvider;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.VanillaServerStatusProvider;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.KeyFrames;
import org.jetbrains.annotations.Nullable;
import reactor.core.Disposable;
import reactor.core.scheduler.Schedulers;
import sm0keysa1m0n.bliss.Animation;
import sm0keysa1m0n.bliss.style.Percentage;
import sm0keysa1m0n.bliss.style.States;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.View;

public class ServerListView<S extends ServerList>
extends ParentView {
    private final S serverList;
    protected final ParentView listView;
    protected final ParentView controlsView;
    @Nullable
    private ServerItemView selectedItem;
    private final View playButton;
    private final VanillaServerStatusProvider statusProvider = new VanillaServerStatusProvider();
    @Nullable
    private Disposable refreshTask;

    public ServerListView(S serverList) {
        super(new View.Properties());
        this.serverList = serverList;
        this.listView = new ParentView(new View.Properties().styleClasses("list-content"));
        this.addChild(this.listView);
        this.playButton = Theme.createGreenButton((Component)new TranslatableComponent("view.server_list.button.play"), () -> this.getSelectedItem().ifPresent(ServerItemView::connect));
        this.playButton.setEnabled(false);
        this.controlsView = new ParentView(new View.Properties().styleClasses("list-controls"));
        this.controlsView.addChild(this.createTopRowControls());
        this.controlsView.addChild(this.createBottomRowControls());
        this.addChild(this.controlsView);
        this.refresh();
    }

    @Override
    public void tick() {
        super.tick();
        this.statusProvider.tick();
    }

    public S getServerList() {
        return this.serverList;
    }

    public ServerStatusProvider getStatusProvider() {
        return this.statusProvider;
    }

    protected ParentView createTopRowControls() {
        ParentView view = new ParentView(new View.Properties());
        view.addChild(this.playButton);
        return view;
    }

    protected ParentView createBottomRowControls() {
        ParentView view = new ParentView(new View.Properties());
        View quickRefreshButton = Theme.createBlueButton((Component)new TranslatableComponent("view.server_list.button.quick_refresh"), this::quickRefresh);
        view.addChild(quickRefreshButton);
        View refreshButton = Theme.createBlueButton((Component)new TranslatableComponent("view.server_list.button.refresh"), this::refresh);
        view.addChild(refreshButton);
        return view;
    }

    @Override
    protected void added() {
        super.added();
        int delay = 0;
        for (View view : this.listView.getChildren()) {
            new Animator.Builder().addTarget(Animation.forProperty(view.getStyle().xTranslation).keyFrames((KeyFrames<Float>)new KeyFrames.Builder((Object)Float.valueOf(-100.0f)).addFrame((Object)Float.valueOf(0.0f)).build()).build()).addTarget(Animation.forProperty(view.getStyle().opacity).keyFrames((KeyFrames<Percentage>)new KeyFrames.Builder((Object)Percentage.ZERO).addFrame((Object)Percentage.ONE_HUNDRED).build()).build()).setStartDelay((long)delay, TimeUnit.MILLISECONDS).setDuration(200L, TimeUnit.MILLISECONDS).build().start();
            delay += 100;
        }
    }

    @Override
    protected void removed() {
        super.removed();
        if (this.refreshTask != null) {
            this.refreshTask.dispose();
        }
    }

    public void setSelectedItem(@Nullable ServerItemView selectedItem) {
        if (this.selectedItem == selectedItem) {
            return;
        }
        if (this.selectedItem != null) {
            this.selectedItem.getStyleManager().removeState(States.CHECKED);
            this.selectedItem.getStyleManager().notifyListeners();
        }
        this.selectedItem = selectedItem;
        if (selectedItem != null) {
            this.selectedItem.getStyleManager().addState(States.CHECKED);
            this.selectedItem.getStyleManager().notifyListeners();
        }
        this.playButton.setEnabled(selectedItem != null);
    }

    public Optional<ServerItemView> getSelectedItem() {
        return Optional.ofNullable(this.selectedItem);
    }

    private void refresh() {
        if (this.refreshTask != null && !this.refreshTask.isDisposed()) {
            return;
        }
        this.listView.clearChildren();
        this.setSelectedItem(null);
        this.refreshTask = this.serverList.load().publishOn(Schedulers.fromExecutor((Executor)Minecraft.m_91087_())).map(entry -> new ServerItemView(this, (ServerEntry)entry)).doOnNext(this.listView::addChild).then().doAfterTerminate(this.listView::layout).subscribe();
    }

    private void quickRefresh() {
        for (View view : this.listView.getChildren()) {
            if (!(view instanceof ServerItemView)) continue;
            ServerItemView serverItem = (ServerItemView)view;
            serverItem.ping();
        }
    }
}

