/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.server;

import com.craftingdead.immerse.client.gui.screen.ConnectView;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.PingError;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerEntry;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerListView;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerStatusProvider;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.status.ServerStatus;
import org.jetbrains.annotations.Nullable;
import reactor.core.Disposable;
import reactor.core.scheduler.Schedulers;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.event.ActionEvent;

class ServerItemView
extends ParentView {
    private static final Component QUESTION_MARK = new TextComponent("?").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component ELLIPSES = new TextComponent("...");
    private final Iterator<String> animation = Iterators.cycle((Object[])new String[]{"O o o", "o O o", "o o O"});
    private final ServerListView<?> list;
    private final ServerEntry serverEntry;
    private final TextView descriptionView;
    private final TextView pingView;
    private final TextView playerCountView;
    private long lastAnimationUpdateMs;
    @Nullable
    private Disposable pingTask;

    ServerItemView(ServerListView<?> list, ServerEntry serverEntry) {
        super(new View.Properties().styleClasses("item").doubleClick(true).focusable(true));
        this.list = list;
        this.serverEntry = serverEntry;
        this.descriptionView = new TextView(new View.Properties().id("motd")).setWrap(false);
        this.pingView = new TextView(new View.Properties().id("ping"));
        this.playerCountView = new TextView(new View.Properties().id("players"));
        this.eventBus().subscribe(ActionEvent.class, event -> this.connect());
        this.addChild(this.descriptionView);
        this.addChild(new TextView(new View.Properties().id("map")).setText((FormattedText)new TextComponent(this.serverEntry.map() == null ? "-" : this.serverEntry.map()).m_130940_(ChatFormatting.GRAY)).setWrap(false));
        this.addChild(this.pingView);
        this.addChild(this.playerCountView);
        this.ping();
    }

    @Override
    public void tick() {
        super.tick();
        long currentTime = Util.m_137550_();
        if (this.lastAnimationUpdateMs != -1L && currentTime - this.lastAnimationUpdateMs >= 100L) {
            this.lastAnimationUpdateMs = currentTime;
            this.descriptionView.setText((FormattedText)new TextComponent(this.animation.next()));
        }
    }

    @Override
    public void keyPressed(int keyCode, int scanCode, int modifiers) {
        super.keyPressed(keyCode, scanCode, modifiers);
        if (keyCode == 32 && this.isFocused()) {
            this.list.setSelectedItem(this);
        }
    }

    @Override
    public boolean mousePressed(double mouseX, double mouseY, int button) {
        if (this.isFocused()) {
            this.list.setSelectedItem(this);
        }
        return super.mousePressed(mouseX, mouseY, button);
    }

    @Override
    protected void removed() {
        super.removed();
        if (this.pingTask != null) {
            this.pingTask.dispose();
        }
    }

    public void connect() {
        this.getScreen().keepOpen();
        this.minecraft.m_91152_(ConnectView.createScreen(this.getScreen(), this.serverEntry.toServerAddress()));
    }

    public ServerEntry getServerEntry() {
        return this.serverEntry;
    }

    public void ping() {
        if (this.pingTask != null && !this.pingTask.isDisposed()) {
            return;
        }
        this.descriptionView.setText((FormattedText)ELLIPSES);
        this.pingView.setText((FormattedText)ELLIPSES);
        this.playerCountView.setText((FormattedText)ELLIPSES);
        this.lastAnimationUpdateMs = 0L;
        this.pingTask = this.list.getStatusProvider().checkStatus(this.serverEntry).publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).doOnNext(this::handlePingResult).doOnError(PingError.class, this::handlePingError).onErrorComplete().subscribe();
    }

    private void handlePingResult(ServerStatusProvider.Result result) {
        ServerStatus status = result.serverStatus();
        this.descriptionView.setText((FormattedText)(status.m_134905_() == null ? QUESTION_MARK : status.m_134905_()));
        if (result.responseTimeMs() >= 0L) {
            long pingMs = result.responseTimeMs();
            ChatFormatting pingColor = pingMs < 200L ? ChatFormatting.GREEN : (pingMs < 400L ? ChatFormatting.YELLOW : (pingMs < 1200L ? ChatFormatting.RED : ChatFormatting.DARK_RED));
            this.pingView.setText((FormattedText)new TextComponent(pingMs + "ms").m_130940_(pingColor));
        } else {
            this.pingView.setText((FormattedText)QUESTION_MARK);
        }
        ServerStatus.Players players = status.m_134914_();
        this.playerCountView.setText((FormattedText)(players == null ? QUESTION_MARK : ServerItemView.formatPlayerCount(players.m_134926_(), players.m_134923_())));
        this.lastAnimationUpdateMs = -1L;
    }

    private void handlePingError(PingError error) {
        this.descriptionView.setText((FormattedText)error.getDescription().m_6881_().m_130940_(ChatFormatting.RED));
        this.lastAnimationUpdateMs = -1L;
    }

    private static Component formatPlayerCount(int playerCount, int maxPlayerCount) {
        return new TextComponent(String.format("%,d", playerCount)).m_7220_((Component)new TextComponent(" / ").m_130940_(ChatFormatting.GRAY)).m_130946_(String.format("%,d", maxPlayerCount)).m_130940_(ChatFormatting.WHITE);
    }
}

