/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.server;

import com.craftingdead.immerse.client.gui.screen.Theme;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.MutableServerList;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerEntry;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerItemView;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerListView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DirectJoinServerScreen;
import net.minecraft.client.gui.screens.EditServerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Flux;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.ViewScreen;

public class MutableServerListView<S extends MutableServerList>
extends ServerListView<S> {
    private View removeButton;

    public MutableServerListView(S serverList) {
        super(serverList);
    }

    @Override
    protected ParentView createTopRowControls() {
        View directConnectButton = Theme.createBlueButton((Component)new TranslatableComponent("view.mutable_server_list.button.direct_connect"), () -> {
            ServerData tempServerData = new ServerData(I18n.m_118938_((String)"selectServer.defaultName", (Object[])new Object[0]), "", false);
            ViewScreen screen = this.getScreen();
            screen.keepOpenAndSetScreen((Screen)new DirectJoinServerScreen((Screen)screen, connect -> {
                if (connect) {
                    ConnectScreen.m_169267_((Screen)screen, (Minecraft)this.minecraft, (ServerAddress)ServerAddress.m_171864_((String)tempServerData.f_105363_), (ServerData)tempServerData);
                } else {
                    this.minecraft.m_91152_((Screen)screen);
                }
            }, tempServerData));
        });
        View addServerButton = Theme.createGreenButton((Component)new TranslatableComponent("view.mutable_server_list.button.add"), () -> {
            ServerData tempServerData = new ServerData(I18n.m_118938_((String)"selectServer.defaultName", (Object[])new Object[0]), "", false);
            ViewScreen screen = this.getScreen();
            screen.keepOpenAndSetScreen((Screen)new EditServerScreen((Screen)screen, success -> {
                if (success) {
                    this.addServer(tempServerData.f_105363_);
                }
                this.minecraft.m_91152_((Screen)screen);
            }, tempServerData));
        });
        ParentView view = super.createTopRowControls();
        view.addChild(directConnectButton);
        view.addChild(addServerButton);
        return view;
    }

    @Override
    protected ParentView createBottomRowControls() {
        this.removeButton = Theme.createRedButton((Component)new TranslatableComponent("view.mutable_server_list.button.remove"), () -> this.getSelectedItem().ifPresent(this::removeServer));
        this.removeButton.setEnabled(false);
        ParentView view = super.createBottomRowControls();
        view.addChild(this.removeButton);
        return view;
    }

    @Override
    public void setSelectedItem(@Nullable ServerItemView selectedItem) {
        super.setSelectedItem(selectedItem);
        this.removeButton.setEnabled(selectedItem != null);
    }

    private void addServer(String host) {
        ServerAddress address = ServerAddress.m_171864_((String)host);
        ServerEntry entry = new ServerEntry(null, address.m_171863_(), address.m_171866_());
        this.listView.addChild(new ServerItemView(this, entry));
        this.listView.layout();
        this.saveServerList();
    }

    private void removeServer(ServerItemView serverItem) {
        this.listView.removeChild(serverItem);
        this.listView.layout();
        this.getSelectedItem().ifPresent(item -> {
            if (item == serverItem) {
                this.setSelectedItem(null);
            }
        });
        this.saveServerList();
    }

    private void saveServerList() {
        Flux.fromIterable(this.listView.getChildren()).ofType(ServerItemView.class).map(ServerItemView::getServerEntry).transform(((MutableServerList)this.getServerList())::save).subscribe();
    }
}

