/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.server;

import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerEntry;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerList;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.nio.file.Files;
import java.nio.file.Path;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class JsonServerList
implements ServerList {
    private static final Gson gson = new Gson();
    private final Path serverListFile;

    public JsonServerList(Path serverListFile) {
        this.serverListFile = serverListFile;
    }

    @Override
    public Flux<ServerEntry> load() {
        return Mono.fromCallable(() -> Files.readString(this.serverListFile)).flatMapIterable(jsonString -> (Iterable)gson.fromJson(jsonString, JsonArray.class)).map(JsonElement::getAsJsonObject).map(json -> new ServerEntry(json.get("map").getAsString(), json.get("hostName").getAsString(), json.get("port").getAsInt())).subscribeOn(Schedulers.boundedElastic());
    }
}

