/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play;

import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.client.gui.screen.Theme;
import com.craftingdead.immerse.client.gui.screen.menu.TransitionView;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.JsonServerList;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.MutableServerListView;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.NbtServerList;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerListView;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.world.WorldListView;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.Interpolator;
import org.jdesktop.core.animation.timing.KeyFrames;
import org.jdesktop.core.animation.timing.TimingTarget;
import org.jdesktop.core.animation.timing.TimingTargetAdapter;
import org.jdesktop.core.animation.timing.interpolators.SplineInterpolator;
import sm0keysa1m0n.bliss.Animation;
import sm0keysa1m0n.bliss.view.DropdownView;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TabsView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;

public class PlayView
extends ParentView
implements TransitionView {
    private final ParentView content = new ParentView(new View.Properties().id("play-content"));
    private final ParentView officialContent = new ParentView(new View.Properties().id("official-content"));
    private final Animator entranceAnimator;
    private final Animator exitAnimator;
    private Runnable removeCallback;

    public PlayView() {
        super(new View.Properties().styleClasses("blur"));
        ParentView officialView = new ParentView(new View.Properties().id("official"));
        ServerListView<JsonServerList> survivalServerListView = new ServerListView<JsonServerList>(new JsonServerList(Paths.get(System.getProperty("user.dir"), "survival_servers.json")));
        ServerListView<JsonServerList> deathmatchServerListView = new ServerListView<JsonServerList>(new JsonServerList(Paths.get(System.getProperty("user.dir"), "tdm_servers.json")));
        officialView.addChild(new TabsView(new View.Properties()).addTab(() -> this.officialContent.replace(survivalServerListView), (FormattedText)new TranslatableComponent("menu.play.tab.survival"), tab -> {
            tab.addActionSound((SoundEvent)ImmerseSoundEvents.TAB_SELECT.get());
            tab.addHoverSound((SoundEvent)ImmerseSoundEvents.TAB_HOVER.get());
        }).addTab(() -> this.officialContent.replace(deathmatchServerListView), (FormattedText)new TranslatableComponent("menu.play.tab.tdm"), tab -> {
            tab.addActionSound((SoundEvent)ImmerseSoundEvents.TAB_SELECT.get());
            tab.addHoverSound((SoundEvent)ImmerseSoundEvents.TAB_HOVER.get());
        }));
        officialView.addChild(this.officialContent);
        WorldListView singleplayerView = new WorldListView();
        MutableServerListView<NbtServerList> customServerListView = new MutableServerListView<NbtServerList>(new NbtServerList(CraftingDeadImmerse.getInstance().getModDir().resolve("custom_servers.dat")));
        this.addChild(new TextView(new View.Properties().id("title")).setText((FormattedText)new TranslatableComponent("menu.play.title")));
        this.addChild(Theme.newSeparator());
        this.addChild(new DropdownView(new View.Properties()).setExpandSound((SoundEvent)ImmerseSoundEvents.DROP_DOWN_EXPAND.get()).setItemHoverSound((SoundEvent)ImmerseSoundEvents.TAB_HOVER.get()).addItem((Component)new TranslatableComponent("menu.play.dropdown.official"), () -> this.dropDownSelect(officialView)).addItem((Component)new TranslatableComponent("menu.play.dropdown.singleplayer"), () -> this.dropDownSelect(singleplayerView)).addItem((Component)new TranslatableComponent("menu.play.dropdown.custom"), () -> this.dropDownSelect(customServerListView)));
        this.addChild(Theme.newSeparator());
        this.addChild(this.content);
        this.entranceAnimator = new Animator.Builder().addTarget(Animation.forProperty(this.getStyle().xTranslation).keyFrames((KeyFrames<Float>)new KeyFrames.Builder((Object)Float.valueOf(-this.graphicsContext.width())).addFrame((Object)Float.valueOf(0.0f)).build()).build()).setInterpolator((Interpolator)new SplineInterpolator((double)0.1f, 1.0, (double)0.1f, 1.0)).setDuration(250L, TimeUnit.MILLISECONDS).build();
        this.exitAnimator = new Animator.Builder().addTarget(Animation.forProperty(this.getStyle().xTranslation).to(Float.valueOf(-this.graphicsContext.width())).build()).setDuration(250L, TimeUnit.MILLISECONDS).addTarget((TimingTarget)new TimingTargetAdapter(){

            public void end(Animator source) {
                PlayView.this.removeCallback.run();
            }
        }).build();
    }

    private void dropDownSelect(View content) {
        this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ImmerseSoundEvents.SUBMENU_SELECT.get()), (float)1.0f));
        this.setContent(content);
    }

    private void setContent(View content) {
        this.content.replace(content);
    }

    @Override
    protected void added() {
        super.added();
        this.entranceAnimator.start();
        this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ImmerseSoundEvents.MAIN_MENU_PRESS_PLAY.get()), (float)1.0f));
    }

    @Override
    protected void removed() {
        super.removed();
        this.entranceAnimator.stop();
        this.exitAnimator.stop();
    }

    @Override
    public void transitionOut(Runnable removeCallback) {
        this.removeCallback = removeCallback;
        this.exitAnimator.start();
    }
}

