/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.game.shop;

import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.immerse.client.gui.screen.game.shop.GameButton;
import com.craftingdead.immerse.client.gui.screen.game.shop.InfoPanel;
import com.craftingdead.immerse.game.module.shop.ClientShopModule;
import com.craftingdead.immerse.game.module.shop.ShopItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemButton
extends GameButton
implements InfoPanel {
    private final ClientShopModule shop;
    private final ShopItem item;

    public ItemButton(ClientShopModule shop, ShopItem item) {
        super(0, 0, 0, 0, item.itemStack().m_41786_(), btn -> shop.buyItem(item.id()));
        this.shop = shop;
        this.item = item;
    }

    private Component getFormattedPrice() {
        return new TextComponent("$" + this.item.price()).m_130940_(this.shop.canAfford(this.item.price()) ? ChatFormatting.GREEN : ChatFormatting.RED);
    }

    @Override
    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6303_(poseStack, mouseX, mouseY, partialTick);
        if (this.item.price() > 0) {
            com.craftingdead.immerse.client.util.RenderUtil.renderTextRight(this.font, poseStack, (float)(this.f_93620_ + this.f_93618_ - 2), (float)(this.f_93621_ + 7), this.getFormattedPrice(), 0, true);
        }
    }

    @Override
    public void renderInfo(Level level, int x, int y, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.font.m_92763_(poseStack, this.m_6035_(), (float)(x - 20), (float)(y - 65), -1);
        ItemButton.m_93215_((PoseStack)poseStack, (Font)this.font, (Component)this.getFormattedPrice(), (int)(x + 53), (int)(y - 75), (int)0);
        RenderUtil.renderItemInCombatSlot((ItemStack)this.item.itemStack(), (int)(x + this.f_93618_ / 2 + 8), (int)(y - 40), (PoseStack)poseStack, (float)partialTick);
        ArrayList itemInfo = new ArrayList();
        this.item.itemStack().m_41720_().m_7373_(this.item.itemStack(), level, itemInfo, (TooltipFlag)TooltipFlag.Default.NORMAL);
        for (int i = 0; i < itemInfo.size(); ++i) {
            Component info = (Component)itemInfo.get(i);
            float f = x - 20;
            Objects.requireNonNull(this.font);
            this.font.m_92763_(poseStack, info, f, (float)(y + (i * 9 + 1)), -1);
        }
    }
}

