/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen;

import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.Interpolator;
import org.jdesktop.core.animation.timing.KeyFrames;
import org.jdesktop.core.animation.timing.interpolators.SplineInterpolator;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.Animation;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.minecraft.MinecraftUtil;
import sm0keysa1m0n.bliss.view.ImageView;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.event.ActionEvent;
import sm0keysa1m0n.bliss.view.event.AddedEvent;
import sm0keysa1m0n.bliss.view.event.RemovedEvent;

public class Theme {
    public static final String RED_BUTTON_CLASS = "red-button";
    public static final String GREEN_BUTTON_CLASS = "green-button";
    public static final String BLUE_BUTTON_CLASS = "blue-button";
    public static final Color ONLINE = Color.create(-7292356);
    public static final Color OFFLINE = Color.GRAY;

    public static View newSeparator() {
        return new View(new View.Properties().styleClasses("seperator").unscaleHeight(true));
    }

    public static View createRedButton(Component text, Runnable actionListener) {
        return Theme.createRedButton(text, actionListener, null);
    }

    public static View createRedButton(Component text, Runnable actionListener, @Nullable String id) {
        return Theme.createButton(text, actionListener, new View.Properties().id(id).styleClasses(RED_BUTTON_CLASS));
    }

    public static View createGreenButton(Component text, Runnable actionListener) {
        return Theme.createGreenButton(text, actionListener, null);
    }

    public static View createGreenButton(Component text, Runnable actionListener, @Nullable String id) {
        return Theme.createButton(text, actionListener, new View.Properties().id(id).styleClasses(GREEN_BUTTON_CLASS));
    }

    public static View createBlueButton(Component text, Runnable actionListener) {
        return Theme.createBlueButton(text, actionListener, null);
    }

    public static View createBlueButton(Component text, Runnable actionListener, @Nullable String id) {
        return Theme.createButton(text, actionListener, new View.Properties().id(id).styleClasses(BLUE_BUTTON_CLASS));
    }

    public static View createButton(Component text, Runnable actionListener, View.Properties properties) {
        ParentView view = new ParentView(properties.styleClasses("button").focusable(true));
        view.addChild(new TextView(new View.Properties().id("label")).setText((FormattedText)text));
        view.addActionSound((SoundEvent)ImmerseSoundEvents.BUTTON_CLICK.get());
        view.eventBus().subscribe(ActionEvent.class, event -> actionListener.run());
        return view;
    }

    public static ImageView createImageButton(ResourceLocation image, Runnable actionListener, View.Properties properties) {
        ImageView view = new ImageView(properties.styleClasses("image-button").focusable(true));
        view.setImage(MinecraftUtil.createImageAccess(image));
        view.addActionSound((SoundEvent)ImmerseSoundEvents.BUTTON_CLICK.get());
        view.addHoverSound((SoundEvent)ImmerseSoundEvents.MAIN_MENU_HOVER.get());
        view.eventBus().subscribe(ActionEvent.class, event -> actionListener.run());
        return view;
    }

    public static View createBackground() {
        ImageView view = new ImageView(new View.Properties().styleClasses("background")).setImage(MinecraftUtil.createImageAccess(new ResourceLocation("craftingdeadimmerse", "textures/gui/background.png")));
        Animator animator = new Animator.Builder().addTarget(Animation.forProperty(view.getStyle().xTranslation).keyFrames((KeyFrames<Float>)new KeyFrames.Builder().addFrames((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(-3.0f), Float.valueOf(5.0f), Float.valueOf(15.0f)}).build()).build()).addTarget(Animation.forProperty(view.getStyle().yTranslation).keyFrames((KeyFrames<Float>)new KeyFrames.Builder().addFrames((Object[])new Float[]{Float.valueOf(10.0f), Float.valueOf(5.0f), Float.valueOf(1.0f), Float.valueOf(3.0f), Float.valueOf(5.0f), Float.valueOf(1.0f), Float.valueOf(-10.0f), Float.valueOf(-7.0f), Float.valueOf(-5.0f)}).build()).build()).addTarget(Animation.forProperty(view.getStyle().xScale).keyFrames((KeyFrames<Float>)new KeyFrames.Builder().addFrames((Object[])new Float[]{Float.valueOf(1.3f), Float.valueOf(1.2f), Float.valueOf(1.25f), Float.valueOf(1.15f)}).build()).build()).addTarget(Animation.forProperty(view.getStyle().yScale).keyFrames((KeyFrames<Float>)new KeyFrames.Builder().addFrames((Object[])new Float[]{Float.valueOf(1.3f), Float.valueOf(1.2f), Float.valueOf(1.25f), Float.valueOf(1.15f)}).build()).build()).setInterpolator((Interpolator)new SplineInterpolator(0.25, 0.1, 0.25, 1.0)).setDuration(20L, TimeUnit.SECONDS).setRepeatCount(-1L).setRepeatBehavior(Animator.RepeatBehavior.REVERSE).build();
        view.eventBus().subscribe(AddedEvent.class, __ -> animator.start());
        view.eventBus().subscribe(RemovedEvent.class, __ -> animator.stop());
        return view;
    }
}

