/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.item.gun.GunConfigOverrides;
import com.craftingdead.immerse.CommonConfig;
import com.craftingdead.immerse.ModDist;
import com.craftingdead.immerse.Permissions;
import com.craftingdead.immerse.client.ClientDist;
import com.craftingdead.immerse.command.ImmerseCommands;
import com.craftingdead.immerse.game.Game;
import com.craftingdead.immerse.game.GameTypes;
import com.craftingdead.immerse.game.LogicalServer;
import com.craftingdead.immerse.game.module.ModuleTypes;
import com.craftingdead.immerse.game.network.GameNetworkChannel;
import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.network.play.SyncLandChunkMessage;
import com.craftingdead.immerse.network.play.SyncLandManagerMessage;
import com.craftingdead.immerse.server.ServerConfig;
import com.craftingdead.immerse.server.ServerDist;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import com.craftingdead.immerse.trading.TradeEventHandler;
import com.craftingdead.immerse.world.action.ImmerseActionTypes;
import com.craftingdead.immerse.world.effect.ImmerseMobEffects;
import com.craftingdead.immerse.world.item.ImmerseItems;
import com.craftingdead.immerse.world.level.block.ImmerseBlocks;
import com.craftingdead.immerse.world.level.block.entity.ImmerseBlockEntityTypes;
import com.craftingdead.immerse.world.level.extension.LandManager;
import com.craftingdead.immerse.world.level.extension.LandOwnerTypes;
import com.craftingdead.immerse.world.level.extension.LevelExtension;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.JarVersionLookupHandler;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import sm0keysa1m0n.bliss.minecraft.platform.LwjglNativeUtil;

@Mod(value="craftingdeadimmerse")
public class CraftingDeadImmerse {
    public static final String ID = "craftingdeadimmerse";
    public static final String VERSION = JarVersionLookupHandler.getImplementationVersion(CraftingDeadImmerse.class).orElse("[version]");
    public static final String DISPLAY_NAME = JarVersionLookupHandler.getImplementationTitle(CraftingDeadImmerse.class).orElse("[display_name]");
    private static final Logger logger = LogUtils.getLogger();
    public static final ServerConfig serverConfig;
    public static final ForgeConfigSpec serverConfigSpec;
    public static final CommonConfig commonConfig;
    public static final ForgeConfigSpec commonConfigSpec;
    private static CraftingDeadImmerse instance;
    private final ModDist modDist;
    private final Path modDir;
    @Nullable
    private LogicalServer logicalServer;

    public CraftingDeadImmerse() {
        instance = this;
        this.modDir = FMLPaths.CONFIGDIR.get().resolve(ID);
        if (!Files.exists(this.modDir, new LinkOption[0])) {
            try {
                Files.createDirectory(this.modDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfigSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonConfigSpec);
        this.modDist = (ModDist)DistExecutor.unsafeRunForDist(() -> ClientDist::new, () -> ServerDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        ImmerseSoundEvents.deferredRegister.register(modEventBus);
        GameTypes.deferredRegister.register(modEventBus);
        ModuleTypes.deferredRegister.register(modEventBus);
        ImmerseActionTypes.deferredRegister.register(modEventBus);
        ImmerseBlocks.deferredRegister.register(modEventBus);
        ImmerseItems.deferredRegister.register(modEventBus);
        ImmerseBlockEntityTypes.deferredRegister.register(modEventBus);
        LandOwnerTypes.deferredRegister.register(modEventBus);
        ImmerseMobEffects.deferredRegister.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new TradeEventHandler());
    }

    @Nullable
    public LogicalServer getLogicalServer() {
        return this.logicalServer;
    }

    public ModDist getModDist() {
        return this.modDist;
    }

    public ClientDist getClientDist() {
        ModDist modDist = this.modDist;
        if (modDist instanceof ClientDist) {
            ClientDist clientDist = (ClientDist)modDist;
            return clientDist;
        }
        throw new IllegalStateException("Accessing client dist on wrong side");
    }

    public Path getModDir() {
        return this.modDir;
    }

    public Game getGame(LogicalSide side) {
        return switch (side) {
            case LogicalSide.CLIENT -> this.getClientDist().getGameClient();
            case LogicalSide.SERVER -> this.getLogicalServer().getGame();
            default -> throw new IllegalArgumentException("Unknown side: " + side.toString());
        };
    }

    public static CraftingDeadImmerse getInstance() {
        return instance;
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        NetworkChannel.loadChannels();
        GameNetworkChannel.load();
    }

    @SubscribeEvent
    public void handlePermissionNodesGather(PermissionGatherEvent.Nodes event) {
        event.addNodes(new PermissionNode[]{Permissions.HYDRATE, Permissions.GAME_OP, Permissions.BASE_DESTROY});
    }

    @SubscribeEvent
    public void handleRegisterCommands(RegisterCommandsEvent event) {
        ImmerseCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void handleServerAboutToStart(ServerAboutToStartEvent event) {
        this.logicalServer = this.modDist.createLogicalServer(event.getServer());
        MinecraftForge.EVENT_BUS.register((Object)this.logicalServer);
        GunConfigOverrides.loadOverrides();
        logger.info("Loaded gun configuration overrides");
    }

    @SubscribeEvent
    public void handleServerStarting(ServerStartingEvent event) {
        this.logicalServer.start();
    }

    @SubscribeEvent
    public void handleServerStopped(ServerStoppedEvent event) {
        if (this.logicalServer != null) {
            this.logicalServer.stop();
            MinecraftForge.EVENT_BUS.unregister((Object)this.logicalServer);
            this.logicalServer = null;
        }
    }

    @SubscribeEvent
    public void handleAttachCapabilities(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(LevelExtension.CAPABILITY_KEY, CapabilityUtil.serializableProvider(() -> LevelExtension.create((Level)event.getObject()), (Capability[])new Capability[]{LevelExtension.CAPABILITY}));
    }

    @SubscribeEvent
    public void handleChunkWatch(ChunkWatchEvent.Watch event) {
        LandManager landManager = LevelExtension.getOrThrow((Level)event.getWorld()).getLandManager();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        landManager.writeChunkToBuf(event.getPos(), buf);
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> ((ChunkWatchEvent.Watch)event).getPlayer()), (Object)new SyncLandChunkMessage(event.getPos(), buf));
    }

    @SubscribeEvent
    public void handleLevelTick(TickEvent.WorldTickEvent event) {
        LevelExtension.getOrThrow(event.world).tick(() -> ((TickEvent.WorldTickEvent)event).haveTime());
    }

    @SubscribeEvent
    public void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CraftingDeadImmerse.sendLandManager((ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public void handlePlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CraftingDeadImmerse.sendLandManager((ServerPlayer)event.getPlayer());
    }

    private static void sendLandManager(ServerPlayer player) {
        LandManager landManager = LevelExtension.getOrThrow((Level)player.m_183503_()).getLandManager();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        landManager.writeToBuf(buf);
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncLandManagerMessage(buf));
    }

    static {
        Pair serverConfigPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        serverConfigSpec = (ForgeConfigSpec)serverConfigPair.getRight();
        serverConfig = (ServerConfig)serverConfigPair.getLeft();
        Pair commonConfigPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        commonConfigSpec = (ForgeConfigSpec)commonConfigPair.getRight();
        commonConfig = (CommonConfig)commonConfigPair.getLeft();
        if (FMLLoader.isProduction() && FMLEnvironment.dist.isClient()) {
            LwjglNativeUtil.load("lwjgl_yoga");
        }
    }
}

