/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.view;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.layout.Layout;
import sm0keysa1m0n.bliss.style.StyleList;
import sm0keysa1m0n.bliss.style.StyleSheetManager;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.View;

public final class ViewScreen
extends Screen {
    private final ParentView root;
    private StyleList styleList;
    @Nullable
    private View hovered;
    @Nullable
    private View focused;
    @Nullable
    private View dragging;
    private boolean keepOpen;
    private boolean layout;

    public ViewScreen(Component title, ParentView root) {
        super(title);
        this.f_96541_ = Minecraft.m_91087_();
        this.f_96543_ = this.f_96541_.m_91268_().m_85445_();
        this.f_96544_ = this.f_96541_.m_91268_().m_85446_();
        this.root = root;
        this.root.setLayout(new Layout(){

            @Override
            public float getX() {
                return 0.0f;
            }

            @Override
            public float getY() {
                return 0.0f;
            }

            @Override
            public float getWidth() {
                return ViewScreen.this.f_96543_;
            }

            @Override
            public float getHeight() {
                return ViewScreen.this.f_96544_;
            }
        });
        this.root.screen = this;
    }

    public ParentView getRoot() {
        return this.root;
    }

    public void keepOpenAndSetScreen(Screen screen) {
        this.keepOpen();
        this.f_96541_.m_91152_(screen);
    }

    public void keepOpen() {
        this.keepOpen = true;
    }

    public void m_7856_() {
        if (this.root.isClosed()) {
            throw new IllegalStateException("Root is closed.");
        }
        this.f_96541_.f_91068_.m_90926_(true);
        if (!this.root.isAdded()) {
            this.root.added();
        }
        this.layout = true;
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
        if (this.keepOpen) {
            this.keepOpen = false;
            return;
        }
        this.root.removed();
        this.root.close();
    }

    private void updateHovered(double mouseX, double mouseY) {
        AtomicReference lowestCommonAncestor = new AtomicReference();
        View hovered = this.root.traverseSortedDepthFirst(view -> view.isMouseOver(mouseX, mouseY), view -> {
            if (view.isHovered()) {
                lowestCommonAncestor.compareAndExchange(null, view);
            }
        }).orElse(null);
        while (this.hovered != null && this.hovered != lowestCommonAncestor.getPlain()) {
            this.hovered.mouseLeft(mouseX, mouseY);
            this.hovered = this.hovered.getParent();
        }
        if (hovered != null) {
            hovered.traverseUpwardUntil(view -> {
                if (view == lowestCommonAncestor.getPlain()) {
                    return true;
                }
                view.mouseEntered(mouseX, mouseY);
                return false;
            });
        }
        this.hovered = hovered;
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.updateHovered(mouseX, mouseY);
        if (this.hovered != null) {
            this.hovered.traverseUpward(view -> view.mouseMoved(mouseX, mouseY));
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        View view = this.hovered;
        boolean foundFocus = false;
        while (this.f_96541_.f_91080_ == this) {
            if (!foundFocus && view.tryFocus(false)) {
                foundFocus = true;
                this.setFocused(view);
            }
            if (view.mousePressed(mouseX, mouseY, button) && this.dragging == null) {
                this.dragging = view;
            }
            if ((view = view.getParent()) != null) continue;
        }
        if (!foundFocus) {
            this.setFocused(null);
        }
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.dragging = null;
        if (this.hovered == null) {
            return false;
        }
        this.hovered.traverseUpward(view -> view.mouseReleased(mouseX, mouseY, button));
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging != null) {
            this.dragging.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.hovered == null) {
            return false;
        }
        this.hovered.traverseUpward(view -> view.mouseScrolled(mouseX, mouseY, scrollDelta));
        this.updateHovered(mouseX, mouseY);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if (keyCode == 258) {
            boolean forward = !ViewScreen.m_96638_();
            this.root.changeFocus(forward).or(() -> this.root.changeFocus(forward)).ifPresent(this::setFocused);
            return false;
        }
        if (this.focused == null) {
            return false;
        }
        this.focused.traverseUpward(view -> view.keyPressed(keyCode, scanCode, modifiers));
        return true;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.focused == null) {
            return false;
        }
        this.focused.traverseUpward(view -> view.keyReleased(keyCode, scanCode, modifiers));
        return true;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.focused == null) {
            return false;
        }
        this.focused.traverseUpward(view -> view.charTyped(codePoint, modifiers));
        return true;
    }

    public View getFocusedView() {
        return this.focused;
    }

    public void setFocused(@Nullable View focused) {
        if (this.focused == focused) {
            return;
        }
        if (this.focused != null) {
            this.focused.removeFocus();
        }
        this.focused = focused;
    }

    public void m_96624_() {
        if (this.layout) {
            this.layout = false;
            this.root.layout();
            double scaledMouseX = this.f_96541_.f_91067_.m_91589_() / this.f_96541_.m_91268_().m_85449_();
            double scaledMouseY = this.f_96541_.f_91067_.m_91594_() / this.f_96541_.m_91268_().m_85449_();
            this.m_94757_(scaledMouseX, scaledMouseY);
        }
        this.root.tick();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.root.graphicsContext.enterManaged();
        this.root.render(poseStack, mouseX, mouseY, partialTicks);
        this.root.graphicsContext.exitManaged();
    }

    public void setStylesheets(List<ResourceLocation> stylesheets) {
        this.styleList = StyleSheetManager.getInstance().createStyleList(stylesheets);
        this.root.refreshStyle();
    }

    public StyleList getStyleList() {
        return this.styleList;
    }
}

