/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.view;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.humbleui.skija.Canvas;
import io.github.humbleui.skija.Font;
import io.github.humbleui.skija.FontMgr;
import io.github.humbleui.skija.FontStyle;
import io.github.humbleui.skija.FontStyleSet;
import io.github.humbleui.skija.Paint;
import io.github.humbleui.skija.PaintMode;
import io.github.humbleui.skija.PaintStrokeCap;
import io.github.humbleui.skija.TextLine;
import io.github.humbleui.skija.shaper.Shaper;
import io.github.humbleui.skija.shaper.ShapingOptions;
import io.github.humbleui.types.Rect;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.layout.MeasureMode;
import sm0keysa1m0n.bliss.style.States;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.event.ActionEvent;

public class DropdownView
extends View {
    public static final int DEFAULT_HEIGHT = 14;
    public static final int DEFAULT_ITEM_BACKGROUND_COLOR = -12303292;
    public static final int DEFAULT_SELECTED_ITEM_BACKGROUND_COLOR = -14540254;
    public static final int DEFAULT_HOVERED_ITEM_BACKGROUND_COLOR = -13421773;
    public static final float DEFAULT_ARROW_WIDTH = 6.0f;
    public static final float DEFAULT_ARROW_HEIGHT = 2.5f;
    public static final float DEFAULT_ARROW_LINE_WIDTH = 1.0f;
    public static final float DEFAULT_X_ARROW_OFFSET = 0.15f;
    private final List<Item> items = new ArrayList<Item>();
    private int itemBackgroundColor;
    private int selectedItemBackgroundColor;
    private int hoveredItemBackgroundColor;
    private boolean expanded = false;
    private int focusedItemIndex;
    private Item selectedItem;
    private float arrowWidth;
    private float arrowHeight;
    private float arrowLineWidth;
    private float xArrowOffset;
    private long fadeStartTimeMs;
    @Nullable
    private SoundEvent expandSound;
    @Nullable
    private SoundEvent itemHoverSound;
    @Nullable
    private Item lastHoveredListener;
    private FontMgr fontManager = FontMgr.getDefault();

    public DropdownView(View.Properties properties) {
        super(properties.focusable(true));
        this.eventBus().subscribe(ActionEvent.class, event -> {
            if (this.expanded) {
                this.getFocusedItem().select();
            }
            this.toggleExpanded();
        });
        this.itemBackgroundColor = -12303292;
        this.selectedItemBackgroundColor = -14540254;
        this.hoveredItemBackgroundColor = -13421773;
        this.arrowWidth = 6.0f;
        this.arrowHeight = 2.5f;
        this.arrowLineWidth = 1.0f;
        this.xArrowOffset = 0.15f;
        this.getStyle().fontFamily.addListener(__ -> this.items.forEach(Item::refreshTextLine));
    }

    @Override
    public void styleRefreshed(FontMgr fontManager) {
        if (this.fontManager != FontMgr.getDefault()) {
            this.fontManager.close();
        }
        this.fontManager = fontManager;
        this.items.forEach(Item::refreshTextLine);
    }

    @Override
    public void close() {
        super.close();
        if (this.fontManager != FontMgr.getDefault()) {
            this.fontManager.close();
        }
    }

    protected Vec2 measure(MeasureMode widthMode, float width, MeasureMode heightMode, float height) {
        return new Vec2(width, 14.0f);
    }

    public DropdownView setArrowWidth(float arrowWidth) {
        this.arrowWidth = arrowWidth;
        return this;
    }

    public DropdownView setArrowHeight(float arrowHeight) {
        this.arrowHeight = arrowHeight;
        return this;
    }

    public DropdownView setArrowLineWidth(float arrowLineWidth) {
        this.arrowLineWidth = arrowLineWidth;
        return this;
    }

    public DropdownView setXArrowOffset(float xArrowOffset) {
        this.xArrowOffset = xArrowOffset;
        return this;
    }

    public DropdownView setItemBackgroundColour(int itemBackgroundColour) {
        this.itemBackgroundColor = itemBackgroundColour;
        return this;
    }

    public DropdownView setSelectedItemBackgroundColour(int selectedItemBackgroundColour) {
        this.selectedItemBackgroundColor = selectedItemBackgroundColour;
        return this;
    }

    public DropdownView setHoveredItemBackgroundColour(int hoveredItemBackgroundColour) {
        this.hoveredItemBackgroundColor = hoveredItemBackgroundColour;
        return this;
    }

    public DropdownView addItem(Component text, Runnable actionListener) {
        this.items.add(new Item(this.items.size(), text, actionListener));
        return this;
    }

    public DropdownView setDisabled(int itemId, boolean disabled) {
        this.items.get(itemId).setDisabled(disabled);
        return this;
    }

    public DropdownView setExpandSound(@Nullable SoundEvent expandSound) {
        this.expandSound = expandSound;
        return this;
    }

    public DropdownView setItemHoverSound(@Nullable SoundEvent itemHoverSound) {
        this.itemHoverSound = itemHoverSound;
        return this;
    }

    private Item getFocusedItem() {
        return this.items.get(this.focusedItemIndex);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        Item hoveredListener = this.items.stream().filter(item -> item.isMouseOver(mouseX, mouseY)).findFirst().orElse(null);
        if (hoveredListener instanceof Item && hoveredListener != this.lastHoveredListener && this.itemHoverSound != null) {
            this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.itemHoverSound, (float)1.0f));
        }
        this.lastHoveredListener = hoveredListener;
    }

    @Override
    public boolean mousePressed(double mouseX, double mouseY, int button) {
        if (this.expanded) {
            for (Item item : this.items) {
                if (!item.isMouseOver(mouseX, mouseY) || item.disabled) continue;
                this.focusedItemIndex = item.index;
                break;
            }
        }
        return super.mousePressed(mouseX, mouseY, button);
    }

    @Override
    protected void focusChanged() {
        if (!this.isFocused() && this.expanded) {
            this.toggleExpanded();
        }
    }

    @Override
    public Optional<View> changeFocus(boolean forward) {
        if (this.isFocused() && this.expanded) {
            this.getStyleManager().addState(States.FOCUS_VISIBLE);
            this.getStyleManager().notifyListeners();
            this.toggleExpanded();
            return Optional.of(this);
        }
        return super.changeFocus(forward);
    }

    @Override
    protected void layout() {
        super.layout();
        this.items.forEach(Item::refreshTextLine);
    }

    @Override
    protected void added() {
        super.added();
        if (this.items.size() > 0) {
            this.items.get(0).select();
        }
    }

    @Override
    public void keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 264) {
            this.focusedItemIndex = Math.min(this.focusedItemIndex + 1, this.items.size() - 1);
        } else if (keyCode == 265) {
            this.focusedItemIndex = Math.max(this.focusedItemIndex - 1, 0);
        }
        if (!this.expanded) {
            this.getFocusedItem().select();
        }
        super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void toggleExpanded() {
        this.fadeStartTimeMs = Util.m_137550_();
        boolean bl = this.expanded = !this.expanded;
        if (this.expandSound != null) {
            this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.expandSound, (float)1.0f));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        if (!(mouseX > (double)this.getScaledX())) return false;
        if (!(mouseX < (double)(this.getScaledX() + this.getScaledWidth()))) return false;
        if (!(mouseY > (double)this.getScaledY())) return false;
        float f = this.getScaledY() + this.getScaledHeight();
        int n = this.expanded ? this.items.size() * this.getItemHeight() : 0;
        if (!(mouseY < (double)(f + (float)n))) return false;
        return true;
    }

    protected int getItemHeight() {
        return (int)this.getScaledContentHeight();
    }

    @Override
    public void renderContent(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.renderContent(poseStack, mouseX, mouseY, partialTicks);
        this.selectedItem.render(poseStack, Type.SELECTED, this.getAlpha());
        this.renderArrow(poseStack);
        float alpha = Mth.m_14036_((float)((float)(Util.m_137550_() - this.fadeStartTimeMs) / 100.0f), (float)0.0f, (float)1.0f);
        if (!this.expanded) {
            alpha = 1.0f - alpha;
        }
        if (alpha == 0.0f) {
            return;
        }
        for (Item item : this.items) {
            Type type = item.disabled ? Type.DISABLED : (item == this.selectedItem ? Type.HIGHLIGHTED : (item.isMouseOver(mouseX, mouseY) || this.focusedItemIndex == item.index ? Type.HOVERED : Type.NONE));
            item.render(poseStack, type, alpha * this.getAlpha());
        }
    }

    private void renderArrow(PoseStack poseStack) {
        float xOffset = this.getScaledContentX() + this.getScaledContentWidth() * (1.0f - this.xArrowOffset);
        float yOffset = this.getScaledContentY() + (this.getScaledContentHeight() - this.arrowHeight) / 2.0f;
        Canvas canvas = this.graphicsContext.canvas();
        float scale = this.graphicsContext.scale();
        try (Paint paint = new Paint().setStrokeCap(PaintStrokeCap.ROUND).setStrokeWidth(this.arrowLineWidth * this.graphicsContext.scale()).setColor(-1).setMode(PaintMode.FILL);){
            canvas.drawLine(xOffset * scale, yOffset * scale, (xOffset + this.arrowWidth / 2.0f) * scale, (yOffset + this.arrowHeight) * scale, paint);
            canvas.drawLine((xOffset + this.arrowWidth / 2.0f) * scale, (yOffset + this.arrowHeight) * scale, (xOffset + this.arrowWidth) * scale, yOffset * scale, paint);
        }
    }

    public class Item {
        private final int index;
        private final Component text;
        private final Runnable actionListener;
        private boolean disabled = false;
        private TextLine textLine;

        public Item(int index, Component text, Runnable actionListener) {
            this.index = index;
            this.text = text;
            this.actionListener = actionListener;
            this.refreshTextLine();
        }

        private void refreshTextLine() {
            String family;
            Style style = this.text.m_7383_();
            FontStyle fontStyle = style.m_131154_() && style.m_131161_() ? FontStyle.BOLD_ITALIC : (style.m_131154_() ? FontStyle.BOLD : (style.m_131161_() ? FontStyle.ITALIC : FontStyle.NORMAL));
            FontStyleSet fontSet = FontStyleSet.makeEmpty();
            String[] stringArray = (String[])DropdownView.this.getStyle().fontFamily.get();
            int n = stringArray.length;
            for (int i = 0; i < n && (fontSet = DropdownView.this.fontManager.matchFamily(family = stringArray[i])).count() <= 0; ++i) {
            }
            this.textLine = Shaper.make((FontMgr)DropdownView.this.fontManager).shapeLine(this.text.getString(), new Font(fontSet.matchStyle(fontStyle), (float)((Integer)DropdownView.this.getStyle().fontSize.get()).intValue() * DropdownView.this.graphicsContext.scale()), ShapingOptions.DEFAULT);
        }

        private void render(PoseStack poseStack, Type type, float alpha) {
            float y = this.getY();
            int backgroundColor = DropdownView.this.itemBackgroundColor;
            int textColor = ChatFormatting.GRAY.m_126665_();
            switch (type) {
                case SELECTED: {
                    y = DropdownView.this.getScaledContentY();
                    backgroundColor ^= 0;
                    backgroundColor -= Integer.MIN_VALUE;
                    textColor = ChatFormatting.WHITE.m_126665_();
                    break;
                }
                case HIGHLIGHTED: {
                    backgroundColor = DropdownView.this.selectedItemBackgroundColor;
                    break;
                }
                case DISABLED: {
                    textColor = ChatFormatting.DARK_GRAY.m_126665_();
                    break;
                }
                case HOVERED: {
                    backgroundColor = DropdownView.this.hoveredItemBackgroundColor;
                    break;
                }
            }
            this.render(poseStack, DropdownView.this.getScaledContentX(), y, DropdownView.this.getScaledContentWidth(), DropdownView.this.getItemHeight(), backgroundColor, textColor, alpha);
        }

        private void render(PoseStack poseStack, float x, float y, float width, float height, int backgroundColor, int textColor, float alpha) {
            Canvas canvas = DropdownView.this.graphicsContext.canvas();
            Style style = this.text.m_7383_();
            float scale = DropdownView.this.graphicsContext.scale();
            canvas.translate(x * scale, y * scale);
            canvas.scale(DropdownView.this.getXScale(), DropdownView.this.getYScale());
            try (Paint paint = new Paint();){
                paint.setMode(PaintMode.FILL);
                paint.setColor(Color.multiplyAlpha(backgroundColor, alpha));
                canvas.drawRect(Rect.makeWH((float)(width * scale), (float)(height * scale)), paint);
            }
            paint = new Paint();
            try {
                paint.setColor(Color.multiplyAlpha(style.m_131135_() == null ? ((Color)DropdownView.this.getStyle().color.get()).valueHex() : style.m_131135_().m_131265_() + -16777216, alpha));
                canvas.translate(4.0f * scale, this.textLine.getHeight() + height * scale / 2.0f - this.textLine.getXHeight() * 2.0f);
                canvas.drawTextLine(this.textLine, 0.0f, 0.0f, paint);
            }
            finally {
                paint.close();
            }
            canvas.resetMatrix();
        }

        private void select() {
            if (DropdownView.this.selectedItem != this) {
                this.actionListener.run();
                DropdownView.this.selectedItem = this;
            }
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        private float getY() {
            return DropdownView.this.getScaledContentY() + DropdownView.this.getScaledContentHeight() + (float)(DropdownView.this.getItemHeight() * this.index);
        }

        private boolean isMouseOver(double mouseX, double mouseY) {
            float y = this.getY();
            return DropdownView.this.isMouseOver(mouseX, mouseY) && mouseY >= (double)y && mouseY <= (double)(y + (float)DropdownView.this.getItemHeight());
        }
    }

    private static enum Type {
        HIGHLIGHTED,
        SELECTED,
        DISABLED,
        HOVERED,
        NONE;

    }
}

