/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.parser.value;

import io.github.humbleui.skija.paragraph.Shadow;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.Color;
import sm0keysa1m0n.bliss.style.parser.ParserException;
import sm0keysa1m0n.bliss.style.parser.StyleReader;
import sm0keysa1m0n.bliss.style.parser.value.ColorParser;

public class ShadowParser {
    @Nullable
    public static Shadow parse(StyleReader reader) throws ParserException {
        Float xOffset;
        Color color = ColorParser.parse(reader);
        if (color != null) {
            reader.skipWhitespace();
        }
        if ((xOffset = reader.readFloat()) == null) {
            if (color == null) {
                return null;
            }
            throw new ParserException("X-offset expected at index " + reader.getCursor());
        }
        String xOffsetUnit = reader.readUnquotedString();
        if (xOffset.floatValue() != 0.0f && xOffsetUnit == null) {
            throw new ParserException("X-offset unit expected at index " + reader.getCursor());
        }
        reader.skipWhitespace();
        Float yOffset = reader.readFloat();
        if (yOffset == null) {
            throw new ParserException("Y-offset expected at index " + reader.getCursor());
        }
        String yOffsetUnit = reader.readUnquotedString();
        if (yOffset.floatValue() != 0.0f && yOffsetUnit == null) {
            throw new ParserException("Y-offset unit expected at index " + reader.getCursor());
        }
        reader.skipWhitespace();
        Float blurRadius = reader.readFloat();
        if (blurRadius == null) {
            blurRadius = Float.valueOf(0.0f);
        } else {
            String blurRadiusUnit = reader.readUnquotedString();
            if (blurRadius.floatValue() != 0.0f && blurRadiusUnit == null) {
                throw new ParserException("Blur radius unit expected at index " + reader.getCursor());
            }
            reader.skipWhitespace();
        }
        if (color == null && (color = ColorParser.parse(reader)) == null) {
            color = Color.BLACK;
        }
        return new Shadow(color.valueHex(), xOffset.floatValue(), yOffset.floatValue(), (double)blurRadius.floatValue());
    }
}

