/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.style.parser.value;

import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.Length;
import sm0keysa1m0n.bliss.calc.CalcParser;
import sm0keysa1m0n.bliss.style.parser.ParsedFunction;
import sm0keysa1m0n.bliss.style.parser.ParserException;
import sm0keysa1m0n.bliss.style.parser.StyleReader;

public class LengthParser {
    @Nullable
    public static Length parse(StyleReader reader) throws ParserException {
        ParsedFunction func = reader.readFunction();
        if (func != null) {
            switch (func.name()) {
                case "calc": {
                    break;
                }
                default: {
                    throw new ParserException("Unknown length function: " + func.name());
                }
            }
            return Length.calculated(CalcParser.parse(func.arguments()));
        }
        Float val = reader.readFloat();
        if (val != null) {
            if (val.floatValue() == 0.0f) {
                return Length.fixed(0.0f);
            }
            String unit = reader.readUnquotedString();
            if (unit == null) {
                throw new ParserException("Expected unit at index " + reader.getCursor());
            }
            if (unit.equals("%")) {
                return Length.percentage(val.floatValue());
            }
            return Length.fixed(val.floatValue());
        }
        String keyword = reader.readUnquotedString();
        if (keyword != null && keyword.equals("auto")) {
            return Length.AUTO;
        }
        return null;
    }
}

