/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.property;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.Evaluator;
import org.jdesktop.core.animation.timing.Interpolator;
import org.jdesktop.core.animation.timing.TimingTarget;
import org.jdesktop.core.animation.timing.TimingTargetAdapter;
import org.jdesktop.core.animation.timing.evaluators.KnownEvaluators;
import org.jetbrains.annotations.Nullable;
import sm0keysa1m0n.bliss.property.StyleableProperty;

public interface Transition {
    public static final Transition INSTANT = new Transition(){

        @Override
        public <T> Runnable transition(StyleableProperty<T> property, T newValue) {
            property.set(newValue);
            return () -> {};
        }
    };

    public <T> Runnable transition(StyleableProperty<T> var1, T var2);

    public static Transition linear(long durationMs) {
        return Transition.linear(0L, durationMs);
    }

    public static Transition linear(long delayMs, long durationMs) {
        return Transition.create(delayMs, durationMs, null);
    }

    public static Transition create(final long delayMs, final long durationMs, final @Nullable Interpolator interpolator) {
        return new Transition(){

            @Override
            public <T> Runnable transition(final StyleableProperty<T> property, final T newValue) {
                AtomicBoolean stopped = new AtomicBoolean();
                Animator animator = new Animator.Builder().setStartDelay(delayMs, TimeUnit.MILLISECONDS).setDuration(durationMs, TimeUnit.MILLISECONDS).setInterpolator(interpolator).addTarget((TimingTarget)new TimingTargetAdapter(){
                    private final T startValue;
                    private final Evaluator<T> evaluator;
                    {
                        this.startValue = property.get();
                        this.evaluator = KnownEvaluators.getInstance().getEvaluatorFor(property.getType());
                    }

                    public void timingEvent(Animator source, double fraction) {
                        property.set(this.evaluator.evaluate(this.startValue, newValue, fraction));
                    }
                }).build();
                animator.start();
                return () -> {
                    stopped.set(true);
                    animator.stop();
                };
            }
        };
    }
}

