/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.minecraft.platform;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.math.Matrix4f;
import io.github.humbleui.skija.BackendRenderTarget;
import io.github.humbleui.skija.Canvas;
import io.github.humbleui.skija.ColorSpace;
import io.github.humbleui.skija.DirectContext;
import io.github.humbleui.skija.Matrix33;
import io.github.humbleui.skija.PixelGeometry;
import io.github.humbleui.skija.Surface;
import io.github.humbleui.skija.SurfaceColorFormat;
import io.github.humbleui.skija.SurfaceOrigin;
import io.github.humbleui.skija.SurfaceProps;
import java.nio.FloatBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL33;
import sm0keysa1m0n.bliss.platform.Cursor;
import sm0keysa1m0n.bliss.platform.GraphicsContext;
import sm0keysa1m0n.bliss.platform.ScissorStack;

public class MinecraftGraphicsContext
implements GraphicsContext,
AutoCloseable {
    private final DirectContext context;
    private Surface surface;
    private BackendRenderTarget backendRenderTarget;
    private Canvas canvas;
    private final long window;
    private final RenderTarget renderTarget;
    private float scale;
    private long ibeamCursor = 0L;

    public MinecraftGraphicsContext(long window, RenderTarget renderTarget) {
        RenderSystem.m_187554_();
        this.window = window;
        this.renderTarget = renderTarget;
        this.renderTarget.enableStencil();
        this.context = DirectContext.makeGL();
    }

    public void init(float scale) {
        RenderSystem.m_187554_();
        this.scale = scale;
        this.closeRenderTarget();
        this.backendRenderTarget = BackendRenderTarget.makeGL((int)this.renderTarget.f_83915_, (int)this.renderTarget.f_83916_, (int)0, (int)8, (int)this.renderTarget.f_83920_, (int)32856);
        this.surface = Surface.makeFromBackendRenderTarget((DirectContext)this.context, (BackendRenderTarget)this.backendRenderTarget, (SurfaceOrigin)SurfaceOrigin.BOTTOM_LEFT, (SurfaceColorFormat)SurfaceColorFormat.RGBA_8888, (ColorSpace)ColorSpace.getDisplayP3(), (SurfaceProps)new SurfaceProps(PixelGeometry.RGB_H));
        this.canvas = this.surface.getCanvas();
    }

    private void closeRenderTarget() {
        RenderSystem.m_187554_();
        if (this.surface != null) {
            this.surface.close();
            this.surface = null;
        }
        if (this.backendRenderTarget != null) {
            this.backendRenderTarget.close();
            this.backendRenderTarget = null;
        }
    }

    @Override
    public Surface surface() {
        return this.surface;
    }

    @Override
    public Canvas canvas() {
        return this.canvas;
    }

    @Override
    public void enterManaged() {
        RenderSystem.m_187554_();
        RenderSystem.m_69854_((int)3314, (int)0);
        RenderSystem.m_69854_((int)3316, (int)0);
        RenderSystem.m_69854_((int)3315, (int)0);
        RenderSystem.m_69854_((int)3317, (int)4);
        this.context.resetAll();
    }

    @Override
    public void exitManaged() {
        RenderSystem.m_187554_();
        this.surface.flush();
        BufferUploader.m_166835_();
        GL33.glBindSampler((int)0, (int)0);
        RenderSystem.m_69461_();
        GL11.glDisable((int)3042);
        RenderSystem.m_69405_((int)770, (int)1);
        GL11.glBlendFunc((int)770, (int)1);
        RenderSystem.m_69403_((int)32774);
        GL14.glBlendEquation((int)32774);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69458_((boolean)true);
        GL11.glDepthMask((boolean)true);
        RenderSystem.m_69471_();
        GL11.glDisable((int)3089);
        ScissorStack.apply();
        GL11.glDisable((int)2960);
        RenderSystem.m_69465_();
        GL11.glDisable((int)2929);
        GL13.glActiveTexture((int)33984);
        RenderSystem.m_69388_((int)33984);
    }

    @Override
    public void close() {
        RenderSystem.m_187554_();
        this.closeRenderTarget();
        this.context.close();
    }

    public static Matrix33 convert(Matrix4f matrix) {
        float[] arr = new float[16];
        matrix.m_162229_(FloatBuffer.wrap(arr));
        return new Matrix33(new float[]{arr[0], arr[1], arr[3], arr[4], arr[5], arr[7], arr[12], arr[13], arr[15]});
    }

    @Override
    public int width() {
        return this.renderTarget.f_83915_;
    }

    @Override
    public int height() {
        return this.renderTarget.f_83916_;
    }

    @Override
    public float scale() {
        return this.scale;
    }

    @Override
    public void setCursor(Cursor cursor) {
        RenderSystem.m_187554_();
        GLFW.glfwSetCursor((long)this.window, (long)(switch (cursor) {
            default -> throw new IncompatibleClassChangeError();
            case Cursor.DEFAULT -> 0L;
            case Cursor.IBEAM -> this.ibeamCursor == 0L ? (this.ibeamCursor = GLFW.glfwCreateStandardCursor((int)221186)) : this.ibeamCursor;
        }));
    }
}

