/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss.animation;

import org.jdesktop.core.animation.timing.Interpolator;

public class CubicBezierInterpolator
implements Interpolator {
    private double startX;
    private double startY;
    private double endX;
    private double endY;
    private double aX;
    private double aY;
    private double bX;
    private double bY;
    private double cX;
    private double cY;

    public CubicBezierInterpolator(double startX, double startY, double endX, double endY) {
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
    }

    public double interpolate(double time) {
        return this.getBezierCoordinateY(this.getXForTime(time));
    }

    private double getBezierCoordinateY(double time) {
        this.cY = 3.0 * this.startY;
        this.bY = 3.0 * (this.endY - this.startY) - this.cY;
        this.aY = 1.0 - this.cY - this.bY;
        return time * (this.cY + time * (this.bY + time * this.aY));
    }

    private double getXForTime(double time) {
        double z;
        double x = time;
        for (int i = 1; i < 14 && !(Math.abs(z = this.getBezierCoordinateX(x) - time) < 0.001); ++i) {
            x -= z / this.getXDerivate(x);
        }
        return x;
    }

    private double getXDerivate(double t) {
        return this.cX + t * (2.0 * this.bX + 3.0 * this.aX * t);
    }

    private double getBezierCoordinateX(double time) {
        this.cX = 3.0 * this.startX;
        this.bX = 3.0 * (this.endX - this.startX) - this.cX;
        this.aX = 1.0 - this.cX - this.bX;
        return time * (this.cX + time * (this.bX + time * this.aX));
    }
}

