/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.bliss;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.util.Mth;
import org.jdesktop.core.animation.timing.Evaluator;
import org.jdesktop.core.animation.timing.evaluators.KnownEvaluators;
import org.jetbrains.annotations.Nullable;

public record Color(float[] value4f, int[] value4i, int valueHex) {
    private final float[] value4f;
    private final int[] value4i;
    public static final int FULL_ALPHA = -16777216;
    public static final Color TRANSPARENT;
    public static final Color BLACK;
    public static final Color DARK_BLUE;
    public static final Color DARK_GREEN;
    public static final Color DARK_AQUA;
    public static final Color DARK_RED;
    public static final Color DARK_PURPLE;
    public static final Color GOLD;
    public static final Color GRAY;
    public static final Color DARK_GRAY;
    public static final Color BLUE;
    public static final Color GREEN;
    public static final Color AQUA;
    public static final Color RED;
    public static final Color LIGHT_PURPLE;
    public static final Color YELLOW;
    public static final Color WHITE;
    public static final Color BLUE_C;
    public static final Color GRAY_224;
    private static final Color[] VANILLA_COLORS;

    public static Color parseWithFullAlpha(String hex) {
        return Color.parseWithAlpha(hex, 1.0f);
    }

    public static Color parseWithAlpha(String hex, float alpha) {
        int padding = hex.startsWith("#") ? 1 : 0;
        float red = (float)Integer.parseInt(hex.substring(padding, 2 + padding), 16) / 255.0f;
        float green = (float)Integer.parseInt(hex.substring(2 + padding, 4 + padding), 16) / 255.0f;
        float blue = (float)Integer.parseInt(hex.substring(4 + padding, 6 + padding), 16) / 255.0f;
        return Color.create(red, green, blue, alpha);
    }

    public static Color createWithFullAlpha(int hex) {
        return Color.createWithAlpha(hex, 255);
    }

    public static Color createWithAlpha(int hex, int alpha) {
        return Color.create(hex + (alpha << 24));
    }

    public static Color create(int color) {
        int[] color4i = Color.getColor4i(color);
        return new Color(Color.getColor4f(color4i), color4i, color);
    }

    public static Color create(int red, int green, int blue) {
        return Color.create(red, green, blue, 255);
    }

    public static Color create(int red, int green, int blue, int alpha) {
        return Color.create(new int[]{red, green, blue, alpha});
    }

    public static Color create(int[] color) {
        Preconditions.checkArgument((color.length == 4 ? 1 : 0) != 0, (Object)"color must have 4 components.");
        return new Color(Color.getColor4f(color), color, Color.getColorHex(color));
    }

    public static Color create(float red, float green, float blue) {
        return Color.create(red, green, blue, 1.0f);
    }

    public static Color create(float red, float green, float blue, float alpha) {
        return Color.create(new float[]{red, green, blue, alpha});
    }

    public static Color create(float[] color) {
        Preconditions.checkArgument((color.length == 4 ? 1 : 0) != 0, (Object)"color must have 4 components.");
        int[] color4i = Color.getColor4i(color);
        return new Color(color, color4i, Color.getColorHex(color4i));
    }

    public int red() {
        return this.value4i[0];
    }

    public int green() {
        return this.value4i[1];
    }

    public int blue() {
        return this.value4i[2];
    }

    public int alpha() {
        return this.value4i[3];
    }

    public float[] value4f() {
        float[] result = new float[4];
        System.arraycopy(this.value4f, 0, result, 0, 4);
        return result;
    }

    public int[] value4i() {
        int[] result = new int[4];
        System.arraycopy(this.value4i, 0, result, 0, 4);
        return result;
    }

    public int multiplied(float alpha) {
        return Color.multiplyAlpha(this.valueHex, alpha);
    }

    public boolean transparent() {
        return this.alpha() == 0;
    }

    @Override
    public String toString() {
        return "Color[rgba" + Arrays.toString(this.value4i) + " / #" + Integer.toHexString(this.valueHex) + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.valueHex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Color)) return false;
        Color other = (Color)obj;
        if (other.valueHex != this.valueHex) return false;
        return true;
    }

    @Nullable
    public static Color getFormattingColor(int code) {
        if (code >= 0 && code <= 15) {
            return VANILLA_COLORS[code];
        }
        return null;
    }

    public static float lerp(float percent, float start, float end) {
        return start + percent * (end - start);
    }

    public static long lerp(float percent, int colour1, int colour2) {
        return Color.getColorHex(Color.lerp(percent, Color.getColor4i(colour1), Color.getColor4i(colour2)));
    }

    public static int[] lerp(float percent, int[] colour1, int[] colour2) {
        int[] rgba = new int[4];
        for (int i = 0; i < 4; ++i) {
            rgba[i] = (int)Color.lerp(percent, colour1[i], colour2[i]);
        }
        return rgba;
    }

    public static float[] lerp(float percent, float[] colour1, float[] colour2) {
        float[] rgba = new float[4];
        for (int i = 0; i < 4; ++i) {
            rgba[i] = Mth.m_14179_((float)percent, (float)colour1[i], (float)colour2[i]);
        }
        return rgba;
    }

    public static int multiplyAlpha(int color, float alpha) {
        int newAlpha = (int)((float)(color >> 24 & 0xFF) * alpha);
        int rgb = color & 0xFFFFFF;
        return newAlpha << 24 | rgb;
    }

    public static float[] getColor4f(int[] colour4i) {
        return new float[]{(float)colour4i[0] / 255.0f, (float)colour4i[1] / 255.0f, (float)colour4i[2] / 255.0f, (float)colour4i[3] / 255.0f};
    }

    public static int[] getColor4i(int color) {
        int[] rgba = new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color >> 0 & 0xFF, color >> 24 & 0xFF};
        return rgba;
    }

    public static int[] getColor4i(float[] color4f) {
        return new int[]{(int)(color4f[0] * 255.0f), (int)(color4f[1] * 255.0f), (int)(color4f[2] * 255.0f), (int)(color4f[3] * 255.0f)};
    }

    public static int getColorHex(int[] color4i) {
        return (color4i[3] & 0xFF) << 24 | (color4i[0] & 0xFF) << 16 | (color4i[1] & 0xFF) << 8 | (color4i[2] & 0xFF) << 0;
    }

    static {
        KnownEvaluators.getInstance().register((Evaluator)new Evaluator<Color>(){

            public Color evaluate(Color v0, Color v1, double fraction) {
                return Color.create(Color.lerp((float)fraction, v0.value4f(), v1.value4f()));
            }

            public Class<Color> getEvaluatorClass() {
                return Color.class;
            }
        });
        TRANSPARENT = Color.create(0, 0, 0, 0);
        BLACK = Color.create(0, 0, 0);
        DARK_BLUE = Color.create(0, 0, 170);
        DARK_GREEN = Color.create(0, 170, 0);
        DARK_AQUA = Color.create(0, 170, 170);
        DARK_RED = Color.create(170, 0, 0);
        DARK_PURPLE = Color.create(170, 0, 170);
        GOLD = Color.create(255, 170, 0);
        GRAY = Color.create(170, 170, 170);
        DARK_GRAY = Color.create(85, 85, 85);
        BLUE = Color.create(85, 85, 255);
        GREEN = Color.create(85, 255, 85);
        AQUA = Color.create(85, 255, 255);
        RED = Color.create(255, 85, 85);
        LIGHT_PURPLE = Color.create(255, 85, 255);
        YELLOW = Color.create(255, 255, 85);
        WHITE = Color.create(255, 255, 255);
        BLUE_C = Color.create(170, 220, 240);
        GRAY_224 = Color.create(224, 224, 224);
        VANILLA_COLORS = new Color[]{BLACK, DARK_BLUE, DARK_GREEN, DARK_AQUA, DARK_RED, DARK_PURPLE, GOLD, GRAY, DARK_GRAY, BLUE, GREEN, AQUA, RED, LIGHT_PURPLE, YELLOW, WHITE};
    }
}

