/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CompactValue
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VALUE;
    public static final int REPR;

    public CompactValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CompactValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float value() {
        return CompactValue.nvalue(this.address());
    }

    @NativeType(value="uint32_t")
    public int repr() {
        return CompactValue.nrepr(this.address());
    }

    public static CompactValue create(long address) {
        return (CompactValue)CompactValue.wrap(CompactValue.class, (long)address);
    }

    @Nullable
    public static CompactValue createSafe(long address) {
        return address == 0L ? null : (CompactValue)CompactValue.wrap(CompactValue.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CompactValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CompactValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static float nvalue(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VALUE);
    }

    public static int nrepr(long struct) {
        return UNSAFE.getInt(null, struct + (long)REPR);
    }

    static {
        Struct.Layout layout = CompactValue.__struct((Struct.Member[])new Struct.Member[]{CompactValue.__union((Struct.Member[])new Struct.Member[]{CompactValue.__member((int)4), CompactValue.__member((int)4)})});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VALUE = layout.offsetof(1);
        REPR = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CompactValue, Buffer> {
        private static final CompactValue ELEMENT_FACTORY = CompactValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CompactValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float value() {
            return CompactValue.nvalue(this.address());
        }

        @NativeType(value="uint32_t")
        public int repr() {
            return CompactValue.nrepr(this.address());
        }
    }
}

