/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class RocketToast
implements Toast {
    private static final long DISPLAY_TIME = 5000L;
    private static final int MAX_LINE_SIZE = 200;
    private final Token token;
    private Component title;
    private List<FormattedCharSequence> messageLines;
    private long lastChanged;
    private boolean changed;
    private final int width;

    public RocketToast(Token token, Component title, @Nullable Component message) {
        this(token, title, RocketToast.nullToEmpty(message), 160);
    }

    public static RocketToast multiline(Font font, Token token, Component title, Component message) {
        List messageLines = font.m_92923_((FormattedText)message, 200);
        int width = Math.max(200, messageLines.stream().mapToInt(arg_0 -> ((Font)font).m_92724_(arg_0)).max().orElse(200));
        return new RocketToast(token, title, messageLines, width + 30);
    }

    private RocketToast(Token token, Component title, List<FormattedCharSequence> messageLines, int width) {
        this.token = token;
        this.title = title;
        this.messageLines = messageLines;
        this.width = width;
    }

    private static List<FormattedCharSequence> nullToEmpty(@Nullable Component component) {
        return component == null ? List.of() : List.of(component.m_7532_());
    }

    public int m_7828_() {
        return this.width;
    }

    public Toast.Visibility m_7172_(PoseStack poseStack, ToastComponent toasts, long time) {
        if (this.changed) {
            this.lastChanged = time;
            this.changed = false;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_94893_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = this.m_7828_();
        int lineHeight = 12;
        if (width == 160 && this.messageLines.size() <= 1) {
            toasts.m_93228_(poseStack, 0, 0, 0, 64, width, this.m_94899_());
        } else {
            int height = this.m_94899_() + Math.max(0, this.messageLines.size() - 1) * lineHeight;
            int l = 28;
            int i1 = Math.min(4, height - l);
            this.renderBackgroundRow(poseStack, toasts, width, 0, 0, l);
            for (int i = l; i < height - i1; i += 10) {
                this.renderBackgroundRow(poseStack, toasts, width, 16, i, Math.min(16, height - i - i1));
            }
            this.renderBackgroundRow(poseStack, toasts, width, 32 - i1, height - i1, i1);
        }
        if (this.messageLines == null) {
            toasts.m_94929_().f_91062_.m_92889_(poseStack, this.title, 18.0f, (float)lineHeight, -256);
        } else {
            toasts.m_94929_().f_91062_.m_92889_(poseStack, this.title, 18.0f, 7.0f, -256);
            for (int i = 0; i < this.messageLines.size(); ++i) {
                toasts.m_94929_().f_91062_.m_92877_(poseStack, this.messageLines.get(i), 18.0f, (float)(18 + i * lineHeight), -1);
            }
        }
        return time - this.lastChanged < 5000L ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    private void renderBackgroundRow(PoseStack poseStack, ToastComponent toasts, int p_94839_, int p_94840_, int p_94841_, int p_94842_) {
        int i = p_94840_ == 0 ? 20 : 5;
        int j = Math.min(60, p_94839_ - i);
        toasts.m_93228_(poseStack, 0, p_94841_, 0, 64 + p_94840_, i, p_94842_);
        for (int k = i; k < p_94839_ - j; k += 64) {
            toasts.m_93228_(poseStack, k, p_94841_, 32, 64 + p_94840_, Math.min(64, p_94839_ - k - j), p_94842_);
        }
        toasts.m_93228_(poseStack, p_94839_ - j, p_94841_, 160 - j, 64 + p_94840_, j, p_94842_);
    }

    public void reset(Component title, @Nullable Component message) {
        this.title = title;
        this.messageLines = RocketToast.nullToEmpty(message);
        this.changed = true;
    }

    public Token getToken() {
        return this.token;
    }

    public static void add(ToastComponent toasts, Token token, Component title, @Nullable Component message) {
        toasts.m_94922_((Toast)new RocketToast(token, title, message));
    }

    public static void addOrUpdate(ToastComponent toasts, Token token, Component title, @Nullable Component message) {
        RocketToast toast = (RocketToast)toasts.m_94926_(RocketToast.class, (Object)token);
        if (toast == null) {
            RocketToast.add(toasts, token, title, message);
        } else {
            toast.reset(title, message);
        }
    }

    public static void info(Minecraft minecraft, String message) {
        RocketToast.addOrUpdate(minecraft.m_91300_(), Token.INFO, (Component)new TranslatableComponent("toasts.info"), (Component)new TextComponent(message));
    }

    public static void error(Minecraft minecraft, String message) {
        RocketToast.add(minecraft.m_91300_(), Token.ERROR, (Component)new TranslatableComponent("toasts.error"), (Component)new TextComponent(message));
    }

    public static enum Token {
        INFO,
        ERROR;

    }
}

