/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level.extension;

import com.craftingdead.immerse.world.level.extension.BaseLandManager;
import com.craftingdead.immerse.world.level.extension.LandManager;
import com.craftingdead.immerse.world.level.extension.LevelExtension;
import com.craftingdead.immerse.world.level.extension.PersistedLandManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;

final class LevelExtensionImpl
implements LevelExtension {
    private final LandManager landManager;

    LevelExtensionImpl(Level level) {
        if (level instanceof ServerLevel) {
            MinecraftServer server = level.m_142572_();
            LevelStorageSource.LevelStorageAccess storageSource = server.f_129744_;
            Path path = storageSource.m_197394_(level.m_46472_());
            this.landManager = new PersistedLandManager(level, path.resolve("land"), server.m_6365_());
        } else {
            this.landManager = new BaseLandManager(level);
        }
    }

    @Override
    public void tick(BooleanSupplier haveTime) {
        this.landManager.tick(haveTime);
    }

    @Override
    public LandManager getLandManager() {
        return this.landManager;
    }

    @Override
    public void close() throws IOException {
        this.landManager.close();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("landManager", (Tag)this.landManager.save());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.landManager.load(tag.m_128469_("landManager"));
    }
}

