/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.level.extension;

import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.network.play.RegisterLandOwnerMessage;
import com.craftingdead.immerse.network.play.RemoveLandOwnerMessage;
import com.craftingdead.immerse.network.play.SyncLandChunkMessage;
import com.craftingdead.immerse.util.SplittingExecutor;
import com.craftingdead.immerse.world.level.extension.LandClaim;
import com.craftingdead.immerse.world.level.extension.LandManager;
import com.craftingdead.immerse.world.level.extension.LandOwner;
import com.craftingdead.immerse.world.level.extension.LandSection;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BaseLandManager
implements LandManager {
    private static final int SYNC_AREA_THRESHOLD = 1000;
    public static final int BLOCK_DESTRUCTION_CHUNK_SIZE = 8192;
    private static final Logger logger = LogUtils.getLogger();
    protected final Level level;
    protected final Long2ObjectMap<LandSection> sections = new Long2ObjectOpenHashMap();
    protected final Map<UUID, LandOwner> landsOwners = new Object2ObjectLinkedOpenHashMap();
    protected final Multimap<UUID, LandClaim> landClaims = LinkedHashMultimap.create();
    private final SplittingExecutor executor = new SplittingExecutor();
    private final Set<ChunkPos> dirtyChunks = new ObjectOpenHashSet();

    public BaseLandManager(Level level) {
        this.level = level;
    }

    @Override
    public void tick(BooleanSupplier haveTime) {
        this.executor.tick();
        for (ChunkPos chunkPos : this.dirtyChunks) {
            LevelChunk chunk = this.level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            if (chunk == null) continue;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            this.writeChunkToBuf(chunkPos, buf);
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new SyncLandChunkMessage(chunkPos, buf));
        }
        this.dirtyChunks.clear();
    }

    @Override
    public void registerLandOwner(LandOwner landOwner) {
        if (this.landsOwners.put(landOwner.getId(), landOwner) != null) {
            throw new IllegalStateException("Duplicate land owner with ID: " + landOwner.getId().toString());
        }
        if (!this.level.m_5776_()) {
            this.level.m_6907_().forEach(player -> NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new RegisterLandOwnerMessage(landOwner)));
        }
    }

    @Override
    public CompletionStage<Boolean> removeLandOwner(UUID landOwnerId) {
        Collection landClaims;
        if (this.landsOwners.remove(landOwnerId) == null) {
            return CompletableFuture.completedStage(false);
        }
        if (!this.level.m_5776_()) {
            this.level.m_6907_().forEach(player -> NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new RemoveLandOwnerMessage(landOwnerId)));
        }
        if ((landClaims = this.landClaims.get((Object)landOwnerId)) == null) {
            return CompletableFuture.completedStage(true);
        }
        return List.copyOf(landClaims).stream().map(this::removeLandClaim).reduce((a, b) -> a.thenCombine(b, (r1, r2) -> r1 != false && r2 != false)).orElseGet(() -> CompletableFuture.completedStage(true));
    }

    @Override
    public LandOwner getLandOwner(UUID landOwnerId) {
        return this.landsOwners.get(landOwnerId);
    }

    protected boolean isSectionOutOfBounds(long sectionPos) {
        int y = SectionPos.m_123223_((int)SectionPos.m_123225_((long)sectionPos));
        return this.level.m_151562_(y);
    }

    protected static long getSectionPos(ChunkPos chunkPos, int sectionY) {
        return SectionPos.m_123209_((int)chunkPos.f_45578_, (int)sectionY, (int)chunkPos.f_45579_);
    }

    @Nullable
    protected LandSection getOrLoadSection(long sectionPos) {
        return (LandSection)this.sections.get(sectionPos);
    }

    protected void sectionChanged(long sectionPos) {
        this.dirtyChunks.add(SectionPos.m_123184_((long)sectionPos).m_123251_());
    }

    @Override
    public CompletionStage<LandManager.ClaimResult> registerLandClaim(LandClaim landClaim) {
        if (!this.landsOwners.containsKey(landClaim.ownerId())) {
            throw new IllegalStateException("Land owner must be registered before claiming land");
        }
        return this.forRegion(landClaim.boundingBox(), sectionPos -> {
            if (this.isSectionOutOfBounds(sectionPos)) {
                return Optional.of(LandManager.ClaimResult.OUT_OF_BOUNDS);
            }
            LandSection section = this.getOrLoadSection(sectionPos);
            if (section == null) {
                section = new LandSection();
                this.sections.put(sectionPos, (Object)section);
            }
            if (!section.registerLandClaim(landClaim)) {
                return Optional.of(LandManager.ClaimResult.ALREADY_CLAIMED);
            }
            this.sectionChanged(sectionPos);
            return Optional.empty();
        }, LandManager.ClaimResult.SUCCESS).thenCompose(result -> {
            if (result == LandManager.ClaimResult.SUCCESS) {
                this.landClaims.put((Object)landClaim.ownerId(), (Object)landClaim);
                return CompletableFuture.completedStage(LandManager.ClaimResult.SUCCESS);
            }
            return this.removeLandClaim(landClaim).thenApply(__ -> result);
        });
    }

    @Override
    public CompletionStage<Boolean> removeLandClaim(LandClaim landClaim) {
        return this.forRegion(landClaim.boundingBox(), sectionPos -> {
            LandSection section = this.getOrLoadSection(sectionPos);
            if (section == null) {
                return Optional.of(false);
            }
            section.removeLandClaim(landClaim);
            this.sectionChanged(sectionPos);
            return Optional.empty();
        }, true).whenComplete((result, exception) -> this.landClaims.remove((Object)landClaim.ownerId(), (Object)landClaim));
    }

    @Override
    public CompletionStage<Void> destroyBlocks(BlockPos ... toDestroy) {
        return this.destroyBlocks(new LinkedList<BlockPos>(Arrays.asList(BaseLandManager.ensureImmutable(toDestroy))));
    }

    @Override
    public LandClaim getLandClaimAt(BlockPos blockPos) {
        long sectionPos = SectionPos.m_175568_((BlockPos)blockPos);
        LandSection section = this.getOrLoadSection(sectionPos);
        if (section == null) {
            return null;
        }
        return section.getLandClaim(blockPos);
    }

    @Override
    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        ListTag landOwnersTag = new ListTag();
        this.landsOwners.forEach((ownerId, owner) -> {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128362_("ownerId", ownerId);
            entryTag.m_128365_("owner", (Tag)LandOwner.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, owner).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)));
            landOwnersTag.add((Object)entryTag);
        });
        tag.m_128365_("landOwners", (Tag)landOwnersTag);
        ListTag landClaimsTag = new ListTag();
        this.landClaims.asMap().forEach((ownerId, landClaims) -> {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128362_("ownerId", ownerId);
            ListTag entryLandClaimsTag = landClaims.stream().map(landClaim -> (Tag)LandClaim.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, landClaim).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0))).collect(Collectors.toCollection(ListTag::new));
            entryTag.m_128365_("landClaims", (Tag)entryLandClaimsTag);
            landClaimsTag.add((Object)entryTag);
        });
        tag.m_128365_("landClaims", (Tag)landClaimsTag);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        ListTag landOwnersTag = tag.m_128437_("landOwners", 10);
        for (int i = 0; i < landOwnersTag.size(); ++i) {
            CompoundTag entryTag = landOwnersTag.m_128728_(i);
            this.landsOwners.put(entryTag.m_128342_("ownerId"), (LandOwner)LandOwner.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)entryTag.m_128423_("owner")).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)));
        }
        ListTag landClaimsTag = tag.m_128437_("landClaims", 10);
        for (int i = 0; i < landClaimsTag.size(); ++i) {
            CompoundTag entryTag = landClaimsTag.m_128728_(i);
            UUID ownerId = entryTag.m_128342_("ownerId");
            List<LandClaim> entryLandClaims = entryTag.m_128437_("landClaims", 10).stream().map(landClaimTag -> (LandClaim)LandClaim.CODEC.parse((DynamicOps)NbtOps.f_128958_, landClaimTag).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0))).toList();
            this.landClaims.putAll((Object)ownerId, entryLandClaims);
        }
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        out.m_130130_(this.landsOwners.values().size());
        this.landsOwners.values().forEach(landOwner -> out.m_130059_(LandOwner.CODEC, landOwner));
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        this.landsOwners.clear();
        in.m_178364_(buf -> {
            LandOwner landOwner = (LandOwner)buf.m_130057_(LandOwner.CODEC);
            this.landsOwners.put(landOwner.getId(), landOwner);
        });
    }

    @Override
    public void writeChunkToBuf(ChunkPos chunkPos, FriendlyByteBuf out) {
        for (int i = this.level.m_151560_(); i < this.level.m_151561_(); ++i) {
            long sectionPos = BaseLandManager.getSectionPos(chunkPos, i);
            LandSection section = this.getOrLoadSection(sectionPos);
            if (section == null) continue;
            out.writeBoolean(true);
            out.m_130130_(i);
            out.m_130059_(LandSection.CODEC, (Object)section);
        }
        out.writeBoolean(false);
    }

    @Override
    public void readChunkFromBuf(ChunkPos chunkPos, FriendlyByteBuf in) {
        while (in.readBoolean()) {
            int y = in.m_130242_();
            LandSection section = (LandSection)in.m_130057_(LandSection.CODEC);
            long sectionPos = BaseLandManager.getSectionPos(chunkPos, y);
            if (this.isSectionOutOfBounds(sectionPos)) continue;
            this.sections.put(sectionPos, (Object)section);
        }
    }

    @Override
    public void flush(ChunkPos chunkPos) {
    }

    @Override
    public void close() throws IOException {
    }

    private <T> CompletionStage<T> forRegion(BoundingBox boundingBox, LongFunction<Optional<T>> action, T successResult) {
        return this.forRegion(SectionPos.m_123171_((int)boundingBox.m_162395_()), SectionPos.m_123171_((int)boundingBox.m_162396_()), SectionPos.m_123171_((int)boundingBox.m_162398_()), SectionPos.m_123171_((int)boundingBox.m_162399_()), SectionPos.m_123171_((int)boundingBox.m_162400_()), SectionPos.m_123171_((int)boundingBox.m_162401_()), action, successResult);
    }

    private <T> CompletionStage<T> forRegion(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, LongFunction<Optional<T>> action, T successResult) {
        int area = 0;
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    if (area++ > 1000) {
                        int nextX = x;
                        int nextY = y;
                        int nextZ = z;
                        return this.executor.submit(() -> this.forRegion(nextX, nextY, nextZ, maxX, maxY, maxZ, action, successResult)).thenCompose(Function.identity());
                    }
                    Optional<T> result = action.apply(SectionPos.m_123209_((int)x, (int)y, (int)z));
                    if (!result.isPresent()) continue;
                    return CompletableFuture.completedStage(result.get());
                }
            }
        }
        return CompletableFuture.completedStage(successResult);
    }

    private CompletionStage<Void> destroyBlocks(Queue<BlockPos> blocks) {
        BlockPos block = blocks.poll();
        int i = 0;
        while (block != null) {
            this.level.m_7731_(block, Blocks.f_50016_.m_49966_(), 178);
            if (i > 8192) {
                return this.executor.submit(() -> this.destroyBlocks(blocks)).thenCompose(Function.identity());
            }
            block = blocks.poll();
            ++i;
        }
        return CompletableFuture.completedStage(null);
    }

    private static BlockPos[] ensureImmutable(BlockPos[] original) {
        for (int i = 0; i < original.length; ++i) {
            original[i] = original[i].m_7949_();
        }
        return original;
    }
}

