/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.world.action;

import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.immerse.game.survival.SurvivalPlayerHandler;
import com.craftingdead.immerse.world.action.BuildAction;
import com.craftingdead.immerse.world.level.extension.LevelExtension;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BuildActionType
extends ItemActionType<BuildAction> {
    public static final BiPredicate<LivingExtension<?, ?>, BlockPos> WITHIN_BASE = (performer, blockPos) -> LevelExtension.getOrThrow(performer.level()).getLandManager().getLandOwnerAt((BlockPos)blockPos).map(owner -> owner.isAllowedToBuild((Entity)performer.entity(), (BlockPos)blockPos)).orElse(false);
    public static final BiPredicate<LivingExtension<?, ?>, BlockPos> NOT_CLAIMED = (performer, blockPos) -> !LevelExtension.getOrThrow(performer.level()).getLandManager().isLandClaimed((BlockPos)blockPos);
    public static final BiPredicate<LivingExtension<?, ?>, BlockPos> DONT_OWN_BASE = (performer, blockPos) -> performer.getHandler(SurvivalPlayerHandler.TYPE).map(handler -> handler.getBase().isEmpty()).orElse(true);
    public static final BiConsumer<LivingExtension<?, ?>, BlockPos> NOTIFY_BASE = (performer, blockPos) -> LevelExtension.getOrThrow(performer.level()).getLandManager().getLandOwnerAt((BlockPos)blockPos).ifPresent(base -> base.playerPlacedBlock((LivingExtension<?, ?>)performer, (BlockPos)blockPos));
    private final BiPredicate<LivingExtension<?, ?>, BlockPos> predicate;
    private final BiConsumer<LivingExtension<?, ?>, BlockPos> placementHandler;

    protected BuildActionType(Builder<?> builder) {
        super(builder);
        this.predicate = builder.predicate;
        this.placementHandler = builder.placementHandler;
    }

    public BiPredicate<LivingExtension<?, ?>, BlockPos> getPlacementPredicate() {
        return this.predicate;
    }

    public BiConsumer<LivingExtension<?, ?>, BlockPos> getBlockPlacementHandler() {
        return this.placementHandler;
    }

    protected abstract BuildAction create(LivingExtension<?, ?> var1, BlockPlaceContext var2);

    public void encode(BuildAction action, FriendlyByteBuf out) {
        out.m_130068_((Enum)action.getHand());
        out.m_130062_(action.getContext().m_43718_());
    }

    public BuildAction decode(LivingExtension<?, ?> performer, FriendlyByteBuf in) {
        Player player;
        LivingEntity livingEntity;
        InteractionHand hand = (InteractionHand)in.m_130066_(InteractionHand.class);
        BlockHitResult hitResult = in.m_130283_();
        BlockPlaceContext context = new BlockPlaceContext(performer.level(), (livingEntity = performer.entity()) instanceof Player ? (player = (Player)livingEntity) : null, hand, performer.entity().m_21120_(hand), hitResult);
        return this.create(performer, context);
    }

    public Optional<Action> createBlockAction(LivingExtension<?, ?> performer, UseOnContext context) {
        return Optional.of(this.create(performer, new BlockPlaceContext(context)));
    }

    public static abstract class Builder<SELF extends Builder<SELF>>
    extends ItemActionType.Builder<SELF> {
        private BiPredicate<LivingExtension<?, ?>, BlockPos> predicate = (performer, blockPos) -> true;
        private BiConsumer<LivingExtension<?, ?>, BlockPos> placementHandler = (performer, blockPos) -> {};

        public SELF withinBase() {
            this.predicate = this.predicate.and(WITHIN_BASE);
            this.placementHandler = this.placementHandler.andThen(NOTIFY_BASE);
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF notClaimed() {
            this.predicate = this.predicate.and(NOT_CLAIMED);
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF dontOwnBase() {
            this.predicate = this.predicate.and(DONT_OWN_BASE);
            return (SELF)((Object)((Builder)this.self()));
        }
    }
}

