/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.util.state;

import com.craftingdead.immerse.util.state.State;
import com.craftingdead.immerse.util.state.StateInstance;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.function.Consumer;

public class StateMachine<T extends State<CTX>, CTX> {
    private final CTX context;
    private final Iterator<T> states;
    private final Consumer<T> transitionHandler;
    private StateInstance<CTX> currentState;
    private boolean finished;

    public StateMachine(CTX context, T[] states, Consumer<T> transitionHandler) {
        this(context, Lists.newArrayList((Object[])states), transitionHandler);
    }

    public StateMachine(CTX context, Iterable<T> states, Consumer<T> transitionHandler) {
        this.context = context;
        this.states = states.iterator();
        this.transitionHandler = transitionHandler;
        this.nextState();
    }

    public boolean nextState() {
        if (!this.states.hasNext()) {
            this.finished = true;
            return true;
        }
        State nextState = (State)this.states.next();
        this.currentState = nextState.newInstance(this.context);
        this.transitionHandler.accept(nextState);
        return false;
    }

    public boolean tick() {
        if (this.currentState.tick()) {
            this.nextState();
        }
        return this.finished;
    }

    public StateInstance<CTX> getCurrentState() {
        return this.currentState;
    }
}

