/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.CrashReport;
import org.jetbrains.annotations.Nullable;

public final class CrashReportUtil {
    private static final Method GET_EXCEPTION_METHOD = CrashReportUtil.locateGetExceptionMethod();
    private static final Field THROWABLE_FIELD = CrashReportUtil.locateThrowableField();

    private CrashReportUtil() {
    }

    @Nullable
    public static Throwable extractThrowable(CrashReport crashReport) {
        if (GET_EXCEPTION_METHOD != null) {
            try {
                return (Throwable)GET_EXCEPTION_METHOD.invoke((Object)crashReport, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (THROWABLE_FIELD != null) {
            try {
                return (Throwable)THROWABLE_FIELD.get(crashReport);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static Method locateGetExceptionMethod() {
        try {
            Method method = CrashReport.class.getMethod("getException", new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException | SecurityException ignored) {
            return null;
        }
    }

    @Nullable
    private static Field locateThrowableField() {
        for (Field field : CrashReport.class.getDeclaredFields()) {
            if (!Throwable.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }
}

