/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.trading.network;

import com.craftingdead.immerse.client.trading.ClientTradePacketHandler;
import com.craftingdead.immerse.trading.TradeRequestManager;
import com.craftingdead.immerse.trading.TradeSession;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class UpdateTradeSlotMessage {
    private final int slotIndex;
    private final ItemStack itemStack;
    private final boolean isOtherPlayer;

    public UpdateTradeSlotMessage(int slotIndex, ItemStack itemStack, boolean isOtherPlayer) {
        this.slotIndex = slotIndex;
        this.itemStack = itemStack;
        this.isOtherPlayer = isOtherPlayer;
    }

    public static void encode(UpdateTradeSlotMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotIndex);
        buffer.m_130055_(message.itemStack);
        buffer.writeBoolean(message.isOtherPlayer);
    }

    public static UpdateTradeSlotMessage decode(FriendlyByteBuf buffer) {
        return new UpdateTradeSlotMessage(buffer.readInt(), buffer.m_130267_(), buffer.readBoolean());
    }

    public static boolean handle(UpdateTradeSlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                TradeSession session = TradeRequestManager.getInstance().getTradeSession(player.m_142081_());
                if (session != null) {
                    session.updateSlot(player, message.slotIndex, message.itemStack);
                }
            } else {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientTradePacketHandler.handleUpdateTradeSlot(message));
            }
        });
        context.setPacketHandled(true);
        return true;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean isOtherPlayer() {
        return this.isOtherPlayer;
    }
}

