/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.trading.network;

import com.craftingdead.immerse.client.trading.ClientTradePacketHandler;
import com.craftingdead.immerse.trading.TradeCancelReason;
import com.craftingdead.immerse.trading.TradeRequestManager;
import com.craftingdead.immerse.trading.TradeSession;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class CancelTradeMessage {
    private final TradeCancelReason reason;

    public CancelTradeMessage(TradeCancelReason reason) {
        this.reason = reason;
    }

    public static void encode(CancelTradeMessage message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.reason);
    }

    public static CancelTradeMessage decode(FriendlyByteBuf buffer) {
        return new CancelTradeMessage((TradeCancelReason)buffer.m_130066_(TradeCancelReason.class));
    }

    public static boolean handle(CancelTradeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                TradeSession session = TradeRequestManager.getInstance().getTradeSession(player.m_142081_());
                if (session != null) {
                    session.cancel(TradeCancelReason.PLAYER_CANCELLED);
                }
            } else {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientTradePacketHandler.handleCancelTrade(message));
            }
        });
        context.setPacketHandled(true);
        return true;
    }

    public TradeCancelReason getReason() {
        return this.reason;
    }
}

